/*

Copyright (c) 2009-2018, Thanos Theo. All rights reserved.
Released Under a Simplified BSD (FreeBSD) License
for academic, personal & non-commercial use.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those
of the author and should not be interpreted as representing official policies,
either expressed or implied, of the FreeBSD Project.

A Commercial License is also available for commercial use with
special restrictions and obligations at a one-off fee. See links at:
1. http://www.dotredconsultancy.com/openglrenderingenginetoolrelease.php
2. http://www.dotredconsultancy.com/openglrenderingenginetoolsourcecodelicence.php
Please contact Thanos Theo (thanos.theo@dotredconsultancy.com) for more information.

*/

#pragma once

#ifndef __TestAbstractBase_h
#define __TestAbstractBase_h

#include "ModuleDLL.h"
#include "glew.h"
#if defined(_WIN32)
  #include "wglew.h"
#elif !defined(__APPLE__) || defined(GLEW_APPLE_GLX)
  #include "glxew.h"
#endif
#include "freeglut.h"
#include "AccurateTimers.h"
#include "Randomizers.h"
#include <string>

namespace OpenGLRenderingEngine // used for forward-declarations
{
  class OpenGLDriverInfo;
  class OpenGLEulerCamera;
}

/** @brief Namespace OpenGLRenderingEngineTests for the OpenGL rendering engine tests.
* @author Thanos Theo, 2018
* @version 14.0.0.0
*/
namespace OpenGLRenderingEngineTests
{
  /** @brief TestAbstractBase is the abstract base class for all GLUT tests. Its constructors & virtual destructor are protected for this reason.
  * @author Thanos Theo, 2009-2018
  * @version 14.0.0.0
  */
  class OPENGL_RENDERING_ENGINE_TESTS_MODULE_API TestAbstractBase
  {
  public:

    TestAbstractBase(const TestAbstractBase&) = delete; // copy-constructor delete
    TestAbstractBase(TestAbstractBase&&)      = delete; // move-constructor delete
    TestAbstractBase& operator=(const TestAbstractBase&) = delete; //      assignment operator delete
    TestAbstractBase& operator=(TestAbstractBase&&)      = delete; // move-assignment operator delete

  protected:

    #define getFont() (GLUT_BITMAP_9_BY_15)

    static constexpr std::size_t GLUT_TEXT_WIDTH                                           = 9;
    static constexpr std::size_t GLUT_TEXT_HEIGHT                                          = 15;
    static constexpr std::size_t NUMBER_OF_LIGHTS                                          = 2;
    static constexpr bool USE_COLOR_MATERIAL                                               = true;
    static constexpr std::size_t ENVIRONMENT_MAPPING_RATIO_FACTOR                          = 1;
    static constexpr std::size_t DEPTH_STENCIL_RATIO_FACTOR                                = 1;
    static constexpr std::size_t DEPTH_STENCIL_MULTIPLICATION_FACTOR                       = 2;
    static constexpr std::size_t FULLSCREEN_MAPPING_RATIO_FACTOR                           = 1;
    static constexpr std::size_t A_BUFFER_3D_MAX_SIZE                                      = 256;
    static constexpr GLuint ACTIVE_TEXTURE_UNIT_FOR_2D_TEXTURE                             = 0;
    static constexpr GLuint ACTIVE_TEXTURE_UNIT_FOR_BLUR_XY_TEXTURE                        = 1;
    static constexpr GLuint ACTIVE_TEXTURE_UNIT_FOR_PERLIN_NOISE_3D_TEXTURE                = 2;
    static constexpr GLuint ACTIVE_TEXTURE_UNIT_FOR_A_BUFFER_3D_COUNTER                    = 3;
    static constexpr GLuint ACTIVE_TEXTURE_UNIT_FOR_A_BUFFER_3D                            = 4;
    static constexpr GLuint ACTIVE_TEXTURE_UNIT_FOR_A_BUFFER_3D_LINKED_LIST_ATOMIC_COUNTER = 5;
    static constexpr GLuint ACTIVE_TEXTURE_UNIT_FOR_A_BUFFER_3D_LINKED_LIST_OFFSET         = 6;
    static constexpr GLuint ACTIVE_TEXTURE_UNIT_FOR_A_BUFFER_3D_LINKED_LIST                = 7;
    static constexpr bool DEPTH_OF_FIELD_DEBUG_MODE                                        = false;
    static constexpr GLuint NORMAL_SHADING_BUFFER_ELEMENTS                                 = 3;
    static constexpr GLuint NORMAL_SHADING_LINKED_LIST_BUFFER_ELEMENTS                     = 4;
    static constexpr GLuint DEFERRED_SHADING_BUFFER_ELEMENTS                               = 9;
    static constexpr GLuint DEFERRED_SHADING_LINKED_LIST_BUFFER_ELEMENTS                   = 10;

    OpenGLRenderingEngine::OpenGLDriverInfo* openGLDriverInfo   = nullptr;
    OpenGLRenderingEngine::OpenGLEulerCamera* openGLEulerCamera = nullptr;

    int screenWidth                            = 0;
    int screenHeight                           = 0;
    int vsynch                                 = 1;
    int autoRotate                             = 0;
    bool blackOrWhiteBackground                = true;
    int wireframe                              = 0;
    bool useMotionBlurForScene                 = false;
    float motionBlurSize                       = 0.6f;
    bool reInitMotionBlurForScene              = false;
    int useUIInformation                       = 1;
    GLuint useUIInformationDisplayList         = 0;
    bool reInitUIInformation                   = true;
    bool useFXAA_Antialias                     = false;
    bool takeScreenshot                        = false;

    bool mouseLeftDown                         = false;
    bool mouseMiddleDown                       = false;
    bool mouseRightDown                        = false;
    double mouseX                              = 0.0;
    double mouseY                              = 0.0;
    double cameraAngleX                        = 0.0;
    double cameraAngleY                        = 0.0;
    double cameraDistanceX                     = 0.0;
    double cameraDistanceY                     = 0.0;
    double cameraDistanceZ                     = 15.0;

    Utils::Randomizers::RandomRNGWELL512 random;
    Utils::AccurateTimers::AccurateCPUTimer timer;
    int fpsCounter                             = 59;
    std::string fpsString                      = "";

    std::string textureFileName                = "";
    std::string modelFileName                  = "";
    std::string modelLoaderDescriptorFileName  = "";
    bool multisample                           = false;
    GLfloat shaderTimer                        = 0.0f;

    void writeScreenshotToFile(bool useDevIL = true) const;
    void releaseAllGLResources();

    TestAbstractBase();
    TestAbstractBase(int thisScreenWidth, int thisScreenHeight,                                         const std::string& thisModelFileName, const std::string& thisModelLoaderDescriptorFileName, bool thisMultisample);
    TestAbstractBase(int thisScreenWidth, int thisScreenHeight, const std::string& thisTextureFileName, const std::string& thisModelFileName, const std::string& thisModelLoaderDescriptorFileName, bool thisMultisample);
    virtual ~TestAbstractBase() = default;

  private:

    void performAllGLInitializations();
  };
} // namespace OpenGLRenderingEngineTests

#endif // __TestAbstractBase_h