/*

Copyright (c) 2009-2018, Thanos Theo. All rights reserved.
Released Under a Simplified BSD (FreeBSD) License
for academic, personal & non-commercial use.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those
of the author and should not be interpreted as representing official policies,
either expressed or implied, of the FreeBSD Project.

A Commercial License is also available for commercial use with
special restrictions and obligations at a one-off fee. See links at:
1. http://www.dotredconsultancy.com/openglrenderingenginetoolrelease.php
2. http://www.dotredconsultancy.com/openglrenderingenginetoolsourcecodelicence.php
Please contact Thanos Theo (thanos.theo@dotredconsultancy.com) for more information.

*/

#pragma once

#ifndef __ParticleRenderingSuperQuadricsTest_h
#define __ParticleRenderingSuperQuadricsTest_h

#include "ModuleDLL.h"
#include "TestGLUTInterface.h"
#include "TestAbstractBase.h"
#include "OpenGLShaderProgram.h"
#include <vector>

namespace OpenGLRenderingEngine // used for forward-declarations
{
  class OpenGLModelAmbientLight;
  class OpenGLLight;
  class OpenGLMaterial;
  class OpenGLShaderImpostorModels;
  class OpenGLFrameBufferObject;
  class OpenGLILTexture;
}

/** @brief Namespace OpenGLRenderingEngineTests for the OpenGL rendering engine tests.
* @author Thanos Theo, 2018
* @version 14.0.0.0
*/
namespace OpenGLRenderingEngineTests
{
  /** @brief ParticleRenderingSuperQuadricsTest is the 4th set of OpenGL rendering tests.
  * @author Thanos Theo, 2009-2018
  * @version 14.0.0.0
  */
  class OPENGL_RENDERING_ENGINE_TESTS_MODULE_API ParticleRenderingSuperQuadricsTest final : public TestGLUTInterface, private TestAbstractBase
  {
  public:

    // GLUT related pure virtual functions implemented from TestInterface
    void renderScene() override;
    void changeSize(int w, int h) override;
    void keyboard(unsigned char key, int x, int y) override;
    void specialKeysKeyboard(int key, int x, int y) override;
    void mouse(int button, int state, int x, int y) override;
    void mouseMotion(int x, int y) override;
    void closeFunc() override;

    ParticleRenderingSuperQuadricsTest(int screenWidth, int screenHeight, const std::string& textureFileName, const std::string& modelFileName, const std::string& modelLoaderDescriptorFileName, bool multisample) noexcept;
    ~ParticleRenderingSuperQuadricsTest() = default;
    ParticleRenderingSuperQuadricsTest(const ParticleRenderingSuperQuadricsTest&) = delete;
    ParticleRenderingSuperQuadricsTest(ParticleRenderingSuperQuadricsTest&&)      = delete;
    ParticleRenderingSuperQuadricsTest& operator=(const ParticleRenderingSuperQuadricsTest&) = delete;
    ParticleRenderingSuperQuadricsTest& operator=(ParticleRenderingSuperQuadricsTest&&)      = delete;

  private:

    enum AllCachedRenderingTests : std::size_t { USE_NO_CACHING_METHOD_1 = 0, USE_NO_CACHING_METHOD_2 = 1, USE_VERTEX_ARRAYS = 2, USE_DISPLAY_LISTS = 3, USE_VBOS = 4 };
    AllCachedRenderingTests currentCachedRenderingTest = USE_DISPLAY_LISTS;
    enum AllLightingModels : std::size_t { SIMPLE_LIGHTING = 0, PHONG = 1, BLINN_PHONG = 2, GAUSSIAN = 3, TOON = 4, GOOCH = 5 };
    AllLightingModels currentLightingModel = BLINN_PHONG;
    enum ImpostorShaderUsage : std::size_t { POINT_SPHERE = 0, QUAD_SPHERE_VS_FS = 1, QUAD_SPHERE_VS_GS_FS = 2, QUAD_SPHERE_VS_TESS_LOD_FS = 3, QUAD_SPHERE_VS_TESS_QUAD_FS = 4, CYLINDER_VS_GS_FS = 5 };
    ImpostorShaderUsage currentImpostorShader = QUAD_SPHERE_VS_GS_FS;
    enum ImpostorWireframeUsage : std::size_t { FULL_IMPOSTOR_WIREFRAME = 0, IMPOSTOR_POINTS_ONLY = 1, IMPOSTOR_LINES_ONLY = 2, CYLINDER_EXPLOSION = 3 };
    ImpostorWireframeUsage currentImpostorWireframe = FULL_IMPOSTOR_WIREFRAME;
    enum AllOITModes : std::size_t { NO_OIT = 0, A_BUFFER_3D_USE_TEXTURES = 1, A_BUFFER_3D_USE_BUFFERS = 2, A_BUFFER_3D_USE_LINKED_LIST_TEXTURES = 3, A_BUFFER_3D_USE_LINKED_LIST_BUFFERS = 4 };
    AllOITModes currentOITMode = NO_OIT;
    enum GBUfferEffectTypes : std::size_t { NO_GBUFFER_EFFECT = 0, DEPTH_OF_FIELD = 1, EDGE_ENHANCEMENT = 2, HSSAO = 3, HSSAO_PLUS = 4 };
    GBUfferEffectTypes currentGBUfferEffectType = NO_GBUFFER_EFFECT;

    class OpenGLShaderClearABuffer3D : public OpenGLRenderingEngine::OpenGLShaderProgram
    {
    public:
      // disable two-sided lighting vertex program for Point Sphere Model shaders to get a speed-boost
      OpenGLShaderClearABuffer3D(ParticleRenderingSuperQuadricsTest* thisParticleRenderingSuperQuadricsTest, OpenGLRenderingEngine::OpenGLDriverInfo* openGLDriverInfo) : OpenGLRenderingEngine::OpenGLShaderProgram(openGLDriverInfo, false), particleRenderingSuperQuadricsTest(thisParticleRenderingSuperQuadricsTest) { OpenGLShaderClearABuffer3D::initializeShaderProgram(); }
    private:
      ParticleRenderingSuperQuadricsTest* particleRenderingSuperQuadricsTest = nullptr;
      void initializeShaderProgram() override;
    } *openGLShaderClearABuffer3D = nullptr;
    class OpenGLShaderDisplayABuffer3D : public OpenGLRenderingEngine::OpenGLShaderProgram
    {
    public:
      // disable two-sided lighting vertex program for Point Sphere Model shaders to get a speed-boost
      OpenGLShaderDisplayABuffer3D(ParticleRenderingSuperQuadricsTest* thisParticleRenderingSuperQuadricsTest, OpenGLRenderingEngine::OpenGLDriverInfo* openGLDriverInfo) :OpenGLRenderingEngine::OpenGLShaderProgram(openGLDriverInfo, false), particleRenderingSuperQuadricsTest(thisParticleRenderingSuperQuadricsTest) { OpenGLShaderDisplayABuffer3D::initializeShaderProgram(); }
    private:
      ParticleRenderingSuperQuadricsTest* particleRenderingSuperQuadricsTest = nullptr;
      void initializeShaderProgram() override;
    } *openGLShaderDisplayABuffer3D = nullptr;
    class OpenGLShaderGBufferEffectsBlurXY : public OpenGLRenderingEngine::OpenGLShaderProgram
    {
    public:
      OpenGLShaderGBufferEffectsBlurXY(OpenGLRenderingEngine::OpenGLDriverInfo* openGLDriverInfo) : OpenGLRenderingEngine::OpenGLShaderProgram(openGLDriverInfo) { OpenGLShaderGBufferEffectsBlurXY::initializeShaderProgram(); }
    private:
      void initializeShaderProgram() override;
    } *openGLShaderGBufferEffectsBlurXY = nullptr;
    class OpenGLShaderGBufferEffectsHSSAO : public OpenGLRenderingEngine::OpenGLShaderProgram
    {
    public:
      OpenGLShaderGBufferEffectsHSSAO(OpenGLRenderingEngine::OpenGLDriverInfo* openGLDriverInfo) : OpenGLRenderingEngine::OpenGLShaderProgram(openGLDriverInfo) { OpenGLShaderGBufferEffectsHSSAO::initializeShaderProgram(); }
    private:
      void initializeShaderProgram() override;
    } *openGLShaderGBufferEffectsHSSAO = nullptr;
    class OpenGLShaderGBufferEffects : public OpenGLRenderingEngine::OpenGLShaderProgram
    {
    public:
      OpenGLShaderGBufferEffects(OpenGLRenderingEngine::OpenGLDriverInfo* openGLDriverInfo) : OpenGLRenderingEngine::OpenGLShaderProgram(openGLDriverInfo) { OpenGLShaderGBufferEffects::initializeShaderProgram(); }
    private:
      void initializeShaderProgram() override;
    } *openGLShaderGBufferEffects = nullptr;
    class OpenGLShaderFXAA_Antialias : public OpenGLRenderingEngine::OpenGLShaderProgram
    {
    public:
      OpenGLShaderFXAA_Antialias(OpenGLRenderingEngine::OpenGLDriverInfo* openGLDriverInfo) : OpenGLRenderingEngine::OpenGLShaderProgram(openGLDriverInfo) { OpenGLShaderFXAA_Antialias::initializeShaderProgram(); }
    private:
      void initializeShaderProgram() override;
    } *openGLShaderFXAA_Antialias = nullptr;

    OpenGLRenderingEngine::OpenGLModelAmbientLight* openGLModelAmbientLight                          = nullptr;
    OpenGLRenderingEngine::OpenGLLight* openGLLights[NUMBER_OF_LIGHTS]                               = { nullptr };
    OpenGLRenderingEngine::OpenGLMaterial* openGLMaterial                                            = nullptr;
    OpenGLRenderingEngine::OpenGLShaderImpostorModels* openGLShaderPointSphereModels                 = nullptr;
    OpenGLRenderingEngine::OpenGLShaderImpostorModels* openGLShaderPointSphereModelsQuadVFFS         = nullptr;
    OpenGLRenderingEngine::OpenGLShaderImpostorModels* openGLShaderPointSphereModelsQuadVFGSFS       = nullptr;
    OpenGLRenderingEngine::OpenGLShaderImpostorModels* openGLShaderPointSphereModelsQuadVFTESSLODFS  = nullptr;
    OpenGLRenderingEngine::OpenGLShaderImpostorModels* openGLShaderPointSphereModelsQuadVFTESSQuadFS = nullptr;
    OpenGLRenderingEngine::OpenGLShaderImpostorModels* openGLShaderCylinderVFGSFS                    = nullptr;
    OpenGLRenderingEngine::OpenGLFrameBufferObject* openGLFrameBufferObjectForEnvironmentMapping     = nullptr;
    OpenGLRenderingEngine::OpenGLFrameBufferObject* openGLFrameBufferObjectForGBufferPass1           = nullptr;
    OpenGLRenderingEngine::OpenGLFrameBufferObject* openGLFrameBufferObjectRenderPass2               = nullptr;
    OpenGLRenderingEngine::OpenGLFrameBufferObject* openGLFrameBufferObjectRenderPass3               = nullptr;
    OpenGLRenderingEngine::OpenGLFrameBufferObject* openGLFrameBufferObjectForFXAA_Antialias         = nullptr;
    OpenGLRenderingEngine::OpenGLILTexture* openGLILTexture                                          = nullptr;

    float radiusFactor                               = 1.0f;
    int usePointAntialias                            = 0;
    int usePerspectiveCorrection                     = 0;
    int previousUsePerspectiveCorrection             = 0;
    int depthOfFieldBlurXYNumberOfSamplesRange       = 8;
    float depthOfFieldRange                          = 10.0f;
    float depthOfFieldZFocus                         =  0.5f;
    GLuint rotationTextureID                         = 0;
    std::vector<float> rotationTextureData;
    std::vector<float> depthSamplesData;
    bool useTransparency                             = false;
    bool reInitColorArrays                           = false;

    std::vector<GLdouble> superQuadricVertices;
    std::vector<GLfloat> vertices;
    std::vector<GLfloat> colors;
    std::vector<GLfloat> cylinderVertices;
    std::vector<GLfloat> cylinderDirections;
    std::vector<GLfloat> cylinderColors;

    GLuint allSuperQuadricsDataDisplayList           = 0;
    GLuint VBOColorsID                               = 0;
    GLuint VBOTexCoordsID                            = 0;
    GLuint VBOVerticesAndRadiiID                     = 0;
    GLuint allSuperQuadricsCylinderDataDisplayList   = 0;
    GLuint cylinderVBOColorsID                       = 0;
    GLuint cylinderVBODirectionsID                   = 0;
    GLuint cylinderVBOVerticesAndHeightsID           = 0;

    std::vector<GLfloat> glCachedColors;
    std::vector<GLfloat> glCachedTexCoords;
    std::vector<GLfloat> glCachedPointsAndRadii;

    GLsizei aBuffer3DSize                            = 16;
    GLuint aBuffer3DCounterTextureID                 = 0;
    GLuint aBuffer3DTextureID                        = 0;
    GLuint aBuffer3DCounterBufferID                  = 0;
    GLuint aBuffer3DBufferID                         = 0;
    GLuint64EXT aBuffer3DLinkedListSize              = 1 << 21; // make it GLuint64EXT to reach 4GB+ VRAM
    GLsizei aBuffer3DinkedListMaxSize                = 16;
    GLuint aBuffer3DLinkedListAtomicCounterBufferID  = 0;
    GLuint aBuffer3DLinkedListOffsetTextureID        = 0;
    GLuint aBuffer3DLinkedListTextureID              = 0;
    GLuint aBuffer3DLinkedListOffsetBufferID         = 0;
    GLuint aBuffer3DLinkedListBufferID               = 0;
    bool oitAutoManageABuffer3D                      = 1;
    bool oitSortFragments                            = false;
    bool oitResolveTranslucency                      = false;
    float oitTranslucencyAbsorptionCoefficient       = 10.0f;
    float opacity                                    =  0.0f;
    bool oitUseDeferredShading                       = false;
    bool oitCaptureABuffer3DBufferToFile             = false;
    bool reInitOITShaders                            = false;

    GLfloat allLightsPositions[NUMBER_OF_LIGHTS][3] = { { 0.0f } };

    int useFog                                       = 0;
    int useTexturing                                 = 0;
    int useSphericalMapping                          = 0;
    int useEnvironmentMapping                        = 0;
    int usePositionalLights                          = 0;
    int useOrenNayarDiffuseModel                     = 0;
    int useColoredObjects                            = 1;
    int useSpecularLighting                          = 1;
    int useBackFaceCulling                           = 0;
    int useGeometryExplosion                         = 0;
    int previousAvailableMemory                      = 0;
    int slices                                       = 0;
    int segments                                     = 0;
    int geometryRepetition                           = 0;
    bool reInitSuperQuadricsDataForRendering         = true;
    bool reInitSuperQuadricsCylinderDataForRendering = true;
    int printGLMemoryInfoOnSecondUpdate              = 2; // 2 to avoid printing out GLMemoryInfo on startup
    bool isNavigating                                = false;

    float sinLightAngle                              = 0.0f;
    float cosLightAngle                              = 0.0f;

    GLuint dummyVao                                  = 0;

    void prepareFog() const;
    void prepareLighting();
    void updateLighting();
    void preparePointSphereShaders();
    void prepareABuffer3DShaders();
    void prepareGBufferEffectsShaders();
    void prepareFXAA_AntialiasShaders();
    void prepareTexture();
    void prepareEnvironmentMappingFBO();
    void initEnviromentMappingFBO() const;
    void drawEnvironmentMappingFBO();
    void prepareGBufferEffectsFBOs();
    void prepareHSSAOData();
    void initGBufferEffectsFBOs() const;
    void processGBufferEffectsFBOs();
    void drawGBufferEffectsFBOs();
    void prepareFXAA_AntialiasFBO();
    void initFXAA_AntialiasFBO() const;
    void drawFXAA_AntialiasFBO();
    void initABuffer3D();
    bool autoManageABuffer3D();
    void deleteABuffer3D();
    void writeABuffer3DBufferToFile(GLbitfield barriers) const;

    // Super Quadric creator function
    void initSuperQuadricsShapes();

    void createPointVerticesArray();
    void createPointColorsArray();
    void createPointCylinderVerticesAndDirectionsArray();
    void createPointCylinderColorsArray();
    void createQuadColorsArray();
    void createQuadTextureCoordsArray();
    void createQuadVerticesArray();

    // VBO functions
    void prepareVBOs();
    void deleteVBOs();
    void prepareCylinderVBOs();
    void deleteCylinderVBOs();

    void renderNoCaching(bool skipReInitModelDataForRendering);
    void renderVertexArrays();
    void renderDisplayLists();
    void renderVBOs();
    void renderCylinderNoCaching(bool skipReInitModelDataForRendering);
    void renderCylinderVertexArrays();
    void renderCylinderDisplayLists();
    void renderCylinderVBOs();
    void clearScreen(bool useGBuffer = false) const;
    void disableLights(bool disableAllLightSources = true) const;
    void enableLights(bool enableAllLightSources = true);
    void renderParticleScene(bool environmentMappingRenderPass, bool useGBuffer = false);
    void renderParticleGeometry(bool environmentMappingRenderPass, bool useGBuffer);
    bool isQuadVSFS() const;
    bool isQuadVSTESSFS() const;

    void drawString(const char* str, int x, int y, const float color[4], void* font) const;
    void drawString3D(const char* str, float position[3], const float color[4], void* font) const;
    void showInfo();
    int howMuchCurrentlyAvailableVRAMMemory() const;
    std::string howMuchCurrentlyAvailableVRAMMemoryString() const;
    void showFPS();
  };
} // namespace OpenGLRenderingEngineTests

#endif // __ParticleRenderingSuperQuadricsTest_h