/*

Copyright (c) 2009-2018, Thanos Theo. All rights reserved.
Released Under a Simplified BSD (FreeBSD) License
for academic, personal & non-commercial use.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those
of the author and should not be interpreted as representing official policies,
either expressed or implied, of the FreeBSD Project.

A Commercial License is also available for commercial use with
special restrictions and obligations at a one-off fee. See links at:
1. http://www.dotredconsultancy.com/openglrenderingenginetoolrelease.php
2. http://www.dotredconsultancy.com/openglrenderingenginetoolsourcecodelicence.php
Please contact Thanos Theo (thanos.theo@dotredconsultancy.com) for more information.

*/

#pragma once

#ifndef __ModelLoaderTest_h
#define __ModelLoaderTest_h

#include "ModuleDLL.h"
#include "TestGLUTInterface.h"
#include "TestAbstractBase.h"
#include "OpenGLShaderProgram.h"
#include <unordered_map>
#include <vector>

namespace OpenGLRenderingEngine // used for forward-declarations
{
  class OpenGLModelAmbientLight;
  class OpenGLLight;
  class OpenGLMaterial;
  class OpenGLShaderSurfaceLightingModels;
  class OpenGLShaderSurfaceLightingLODModels;
  class OpenGLFrameBufferObject;
  class OpenGLILTexture;
  class OpenGLAssimpModelLoader;
}

/** @brief Namespace OpenGLRenderingEngineTests for the OpenGL rendering engine tests.
* @author Thanos Theo, 2018
* @version 14.0.0.0
*/
namespace OpenGLRenderingEngineTests
{
  /** @brief ModelLoaderTest is the 3rd set of OpenGL rendering tests.
  * @author Thanos Theo, 2009-2018
  * @version 14.0.0.0
  */
  class OPENGL_RENDERING_ENGINE_TESTS_MODULE_API ModelLoaderTest final : public TestGLUTInterface, private TestAbstractBase
  {
  public:

    // GLUT related pure virtual functions implemented from TestInterface
    void renderScene() override;
    void changeSize(int w, int h) override;
    void keyboard(unsigned char key, int x, int y) override;
    void specialKeysKeyboard(int key, int x, int y) override;
    void mouse(int button, int state, int x, int y) override;
    void mouseMotion(int x, int y) override;
    void closeFunc() override;

    ModelLoaderTest(int screenWidth, int screenHeight, const std::string& textureFileName, const std::string& modelFileName, const std::string& modelLoaderDescriptorFileName, bool multisample) noexcept;
    ~ModelLoaderTest() = default;
    ModelLoaderTest(const ModelLoaderTest&) = delete;
    ModelLoaderTest(ModelLoaderTest&&)      = delete;
    ModelLoaderTest& operator=(const ModelLoaderTest&) = delete;
    ModelLoaderTest& operator=(ModelLoaderTest&&)      = delete;

  private:

    enum AllCachedRenderingTests : std::size_t { USE_NO_CACHING_METHOD_1 = 0, USE_NO_CACHING_METHOD_2 = 1, USE_VERTEX_ARRAYS = 2, USE_DISPLAY_LISTS = 3, USE_VBOS = 4 };
    AllCachedRenderingTests currentCachedRenderingTest = USE_DISPLAY_LISTS;
    enum AllLightingModels : std::size_t { FIXED_PIPELINE = 0, PHONG = 1, BLINN_PHONG = 2, GAUSSIAN = 3, TOON = 4, GOOCH = 5 };
    AllLightingModels currentLightingModel = BLINN_PHONG;
    enum GeometryShaderUsage : std::size_t { NO_USE = 0, PASS_THRU = 1, CREATE_NORMAL_GEOMETRY = 2 };
    GeometryShaderUsage currentGeometryShader = NO_USE;
    enum AllLODModels : std::size_t { PN_TRIANGLES = 0, PHONG_TESSELLATION = 1 };
    AllLODModels currentLODModel = PN_TRIANGLES;
    enum AllAdaptiveTesselationModes : std::size_t { NO_ADAPTIVE_TESSELLATION = 0, ADAPTIVE_TESSELLATION_TRIANGLE_POSITION_METRIC = 1, ADAPTIVE_TESSELLATION_LIGHT_METRIC = 2,
                                                     ADAPTIVE_TESSELLATION_CONTOUR_METRIC = 3, ADAPTIVE_TESSELLATION_ALL_METRICS = 4 };
    AllAdaptiveTesselationModes currentAdaptiveTesselationMode = ADAPTIVE_TESSELLATION_TRIANGLE_POSITION_METRIC;
    enum GBUfferEffectTypes : std::size_t { NO_GBUFFER_EFFECT = 0, DEPTH_OF_FIELD = 1, EDGE_ENHANCEMENT = 2, HSSAO = 3, HSSAO_PLUS = 4 };
    GBUfferEffectTypes currentGBUfferEffectType = NO_GBUFFER_EFFECT;

    class OpenGLShaderGBufferEffectsBlurXY : public OpenGLRenderingEngine::OpenGLShaderProgram
    {
    public:
      OpenGLShaderGBufferEffectsBlurXY(OpenGLRenderingEngine::OpenGLDriverInfo* openGLDriverInfo) : OpenGLRenderingEngine::OpenGLShaderProgram(openGLDriverInfo) { OpenGLShaderGBufferEffectsBlurXY::initializeShaderProgram(); }
    private:
      void initializeShaderProgram() override;
    } *openGLShaderGBufferEffectsBlurXY = nullptr;
    class OpenGLShaderGBufferEffectsHSSAO : public OpenGLRenderingEngine::OpenGLShaderProgram
    {
    public:
      OpenGLShaderGBufferEffectsHSSAO(OpenGLRenderingEngine::OpenGLDriverInfo* openGLDriverInfo) : OpenGLRenderingEngine::OpenGLShaderProgram(openGLDriverInfo) { OpenGLShaderGBufferEffectsHSSAO::initializeShaderProgram(); }
    private:
      void initializeShaderProgram() override;
    } *openGLShaderGBufferEffectsHSSAO = nullptr;
    class OpenGLShaderGBufferEffects : public OpenGLRenderingEngine::OpenGLShaderProgram
    {
    public:
      OpenGLShaderGBufferEffects(OpenGLRenderingEngine::OpenGLDriverInfo* openGLDriverInfo) : OpenGLRenderingEngine::OpenGLShaderProgram(openGLDriverInfo) { OpenGLShaderGBufferEffects::initializeShaderProgram(); }
    private:
      void initializeShaderProgram() override;
    } *openGLShaderGBufferEffects = nullptr;
    class OpenGLShaderFXAA_Antialias : public OpenGLRenderingEngine::OpenGLShaderProgram
    {
    public:
      OpenGLShaderFXAA_Antialias(OpenGLRenderingEngine::OpenGLDriverInfo* openGLDriverInfo) : OpenGLRenderingEngine::OpenGLShaderProgram(openGLDriverInfo) { OpenGLShaderFXAA_Antialias::initializeShaderProgram(); }
    private:
      void initializeShaderProgram() override;
    } *openGLShaderFXAA_Antialias = nullptr;

    OpenGLRenderingEngine::OpenGLModelAmbientLight* openGLModelAmbientLight                                                 = nullptr;
    OpenGLRenderingEngine::OpenGLLight* openGLLights[NUMBER_OF_LIGHTS]                                                      = { nullptr };
    OpenGLRenderingEngine::OpenGLMaterial* openGLMaterial                                                                   = nullptr;
    OpenGLRenderingEngine::OpenGLShaderSurfaceLightingModels* openGLShaderSurfaceLightingModels                             = nullptr;
    OpenGLRenderingEngine::OpenGLShaderSurfaceLightingModels* openGLShaderSurfaceLightingModelsWithGeometry                 = nullptr;
    OpenGLRenderingEngine::OpenGLShaderSurfaceLightingModels* openGLShaderSurfaceLightingModelsWithGeometryAndNormals       = nullptr;
    OpenGLRenderingEngine::OpenGLShaderSurfaceLightingLODModels* openGLShaderSurfaceLightingLODModels                       = nullptr;
    OpenGLRenderingEngine::OpenGLShaderSurfaceLightingLODModels* openGLShaderSurfaceLightingLODModelsWithGeometry           = nullptr;
    OpenGLRenderingEngine::OpenGLShaderSurfaceLightingLODModels* openGLShaderSurfaceLightingLODModelsWithGeometryAndNormals = nullptr;
    OpenGLRenderingEngine::OpenGLFrameBufferObject* openGLFrameBufferObjectForEnvironmentMapping                            = nullptr;
    OpenGLRenderingEngine::OpenGLFrameBufferObject* openGLFrameBufferObjectForHighQualityOutline                            = nullptr;
    OpenGLRenderingEngine::OpenGLFrameBufferObject* openGLFrameBufferObjectForGBufferPass1                                  = nullptr;
    OpenGLRenderingEngine::OpenGLFrameBufferObject* openGLFrameBufferObjectRenderPass2                                      = nullptr;
    OpenGLRenderingEngine::OpenGLFrameBufferObject* openGLFrameBufferObjectRenderPass3                                      = nullptr;
    OpenGLRenderingEngine::OpenGLFrameBufferObject* openGLFrameBufferObjectForFXAA_Antialias                                = nullptr;
    OpenGLRenderingEngine::OpenGLILTexture* openGLILTexture                                                                 = nullptr;
    OpenGLRenderingEngine::OpenGLAssimpModelLoader* openGLAssimpModelLoader                                                 = nullptr;

    bool useLODModels                                     = false;
    float tessellationAlpha                               =  1.0f;
    float tessellationLevel                               = 32.0f;
    bool useAdaptiveTessellation                          = true;
    bool useTrianglePositionAdaptiveTessellationMetric    = true;
    bool useLightAdaptiveTessellationMetric               = false;
    bool useContourAdaptiveTessellationMetric             = false;
    int depthOfFieldBlurXYNumberOfSamplesRange            = 8;
    float depthOfFieldRange                               = 10.0f;
    float depthOfFieldZFocus                              =  0.5f;
    GLuint rotationTextureID                              = 0;
    std::vector<float> rotationTextureData;
    std::vector<float> depthSamplesData;

    GLuint allModelDataDisplayList                        = 0;
    std::unordered_map<int, GLuint> allModelStorageVBOColorsIDs;
    std::unordered_map<int, GLuint> allModelStorageVBONormalsIDs;
    std::unordered_map<int, GLuint> allModelStorageVBOVerticesIDs;
    std::unordered_map<int, GLuint> allModelStorageVBOIndicesIDs;

    GLfloat allLightsPositions[NUMBER_OF_LIGHTS][3] = { { 0.0f } };

    int useFog                                            = 0;
    int useTexturing                                      = 0;
    int useSphericalMapping                               = 0;
    int useEnvironmentMapping                             = 0;
    int useOutline                                        = 0;
    int useHighQualityOutline                             = 0;
    int usePositionalLights                               = 0;
    int useOrenNayarDiffuseModel                          = 0;
    int useFresnelFactorSchlickApproximationSpecularModel = 0;
    int useColoredObjects                                 = 1;
    int useGouraudShading                                 = 1;
    int useBackFaceCulling                                = 0;
    int previousAvailableMemory                           = 0;
    bool reInitModelDataForRendering                      = true;
    int printGLMemoryInfoOnSecondUpdate                   = 2; // 2 to avoid printing out GLMemoryInfo on startup

    float sinLightAngle                                   = 0.0f;
    float cosLightAngle                                   = 0.0f;

    void prepareFog() const;
    void prepareLighting();
    void updateLighting();
    void prepareShaders();
    void prepareLODShaders();
    void prepareGBufferEffectsShaders();
    void prepareFXAA_AntialiasShaders();
    void prepareTexture();
    void prepareScene();
    void prepareEnvironmentMappingFBO();
    void initEnviromentMappingFBO() const;
    void drawEnvironmentMapping();
    void prepareDepthStencilFBO();
    void initDepthStencilFBO() const;
    void prepareGBufferEffectsFBOs();
    void prepareHSSAOData();
    void initGBufferEffectsFBOs() const;
    void processGBufferEffectsFBOs();
    void drawGBufferEffectsFBOs();
    void prepareFXAA_AntialiasFBO();
    void initFXAA_AntialiasFBO() const;
    void drawFXAA_AntialiasFBO();

    // VBO functions
    void prepareVBOs();
    void deleteVBOs();

    void renderNoCaching(bool skipReInitModelDataForRendering);
    void renderVertexArrays();
    void renderDisplayLists();
    void renderVBOs();
    void clearScreen(bool useGBuffer = false) const;
    void disableLights(bool disableAllLightSources = true) const;
    void enableLights(bool enableAllLightSources = true);
    void renderModelScene(bool environmentMappingRenderPass, bool useGBuffer = false);
    void renderModelLoaderGeometry(bool environmentMappingRenderPass, bool useGBuffer, bool enableStencilBufferColor);
    bool isUsingLOD() const;

    void drawString(const char* str, int x, int y, const float color[4], void* font) const;
    void drawString3D(const char* str, float position[3], const float color[4], void* font) const;
    void showInfo();
    int howMuchCurrentlyAvailableVRAMMemory() const;
    std::string howMuchCurrentlyAvailableVRAMMemoryString() const;
    std::string whichAdaptiveTessellationMetric() const;
    void showFPS();
  };
} // namespace OpenGLRenderingEngineTests

#endif // __ModelLoaderTest_h