/*

Copyright (c) 2009-2018, Thanos Theo. All rights reserved.
Released Under a Simplified BSD (FreeBSD) License
for academic, personal & non-commercial use.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those
of the author and should not be interpreted as representing official policies,
either expressed or implied, of the FreeBSD Project.

A Commercial License is also available for commercial use with
special restrictions and obligations at a one-off fee. See links at:
1. http://www.dotredconsultancy.com/openglrenderingenginetoolrelease.php
2. http://www.dotredconsultancy.com/openglrenderingenginetoolsourcecodelicence.php
Please contact Thanos Theo (thanos.theo@dotredconsultancy.com) for more information.

*/

#pragma once

#ifndef __CubeCappingTest_h
#define __CubeCappingTest_h

#include "ModuleDLL.h"
#include "TestGLUTInterface.h"
#include "TestAbstractBase.h"
#include "OpenGLShaderProgram.h"

namespace OpenGLRenderingEngine // used for forward-declarations
{
  class OpenGLFrameBufferObject;
}

/** @brief Namespace OpenGLRenderingEngineTests for the OpenGL rendering engine tests.
* @author Thanos Theo, 2018
* @version 14.0.0.0
*/
namespace OpenGLRenderingEngineTests
{
  /** @brief CubeCappingTest is the 1st set of OpenGL rendering tests.
  * @author Thanos Theo, 2009-2018
  * @version 14.0.0.0
  */
  class OPENGL_RENDERING_ENGINE_TESTS_MODULE_API CubeCappingTest final : public TestGLUTInterface, private TestAbstractBase
  {
  public:

    // GLUT related pure virtual functions implemented from TestGLUTInterface
    void renderScene() override;
    void changeSize(int w, int h) override;
    void keyboard(unsigned char key, int x, int y) override;
    void specialKeysKeyboard(int key, int x, int y) override;
    void mouse(int button, int state, int x, int y) override;
    void mouseMotion(int x, int y) override;
    void closeFunc() override;

    CubeCappingTest(int screenWidth, int screenHeight, bool multisample) noexcept;
    ~CubeCappingTest() = default;
    CubeCappingTest(const CubeCappingTest&) = delete;
    CubeCappingTest(CubeCappingTest&&)      = delete;
    CubeCappingTest& operator=(const CubeCappingTest&) = delete;
    CubeCappingTest& operator=(CubeCappingTest&&)      = delete;

  private:

    enum AllCachedRenderingTests : std::size_t { DRAW_ARRAYS = 0, DRAW_ELEMENTS = 1, DRAW_RANGE_ELEMENTS = 2 };
    AllCachedRenderingTests currentCachedRenderingTest = DRAW_ARRAYS;

    class OpenGLShaderCubeCapping : public OpenGLRenderingEngine::OpenGLShaderProgram
    {
    public:
      OpenGLShaderCubeCapping(OpenGLRenderingEngine::OpenGLDriverInfo* openGLDriverInfo) : OpenGLRenderingEngine::OpenGLShaderProgram(openGLDriverInfo) { OpenGLShaderCubeCapping::initializeShaderProgram(); }
    private:
      void initializeShaderProgram() override;
    } *openGLShaderCubeCapping = nullptr;

    OpenGLRenderingEngine::OpenGLFrameBufferObject* openGLFrameBufferObjectForCubeCapping = nullptr;

    GLuint VBOVerticesID  = 0;
    GLuint VBONormalsID   = 0;
    GLuint VBOTexCoordsID = 0;
    GLuint VBOColorsID    = 0;
    GLuint VBOIndicesID   = 0;

    bool useCubeCapping   = true;
    GLfloat clipPlaneZ    = 0.0f;

    void prepareCubeCappingShaders();
    void prepareCubeCappingFBO();
    void initCubeCappingFBO() const;

    // VBO functions
    void prepareVBOs();
    void deleteVBOs();

    void clearScreen() const;
    void renderCubeClippingPlane() const;
    void renderCube() const;
    void renderCubeScene() const;

    void drawString(const char* str, int x, int y, const GLfloat color[4], void* font) const;
    void drawString3D(const char* str, float position[3], const GLfloat color[4], void* font) const;
    void showInfo();
    void showFPS();
  };
} // namespace OpenGLRenderingEngineTests

#endif // __CubeCappingTest_h