/*

Copyright (c) 2009-2018, Thanos Theo. All rights reserved.
Released Under a Simplified BSD (FreeBSD) License
for academic, personal & non-commercial use.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those
of the author and should not be interpreted as representing official policies,
either expressed or implied, of the FreeBSD Project.

A Commercial License is also available for commercial use with
special restrictions and obligations at a one-off fee. See links at:
1. http://www.dotredconsultancy.com/openglrenderingenginetoolrelease.php
2. http://www.dotredconsultancy.com/openglrenderingenginetoolsourcecodelicence.php
Please contact Thanos Theo (thanos.theo@dotredconsultancy.com) for more information.

*/

#pragma once

#ifndef __ConfigFile_h
#define __ConfigFile_h

#include "ModuleDLL.h"
#include <string>
#include <list>


/** @brief Namespace OpenGLRenderingEngineTests for the OpenGL rendering engine tests.
* @author Thanos Theo, 2018
* @version 14.0.0.0
*/
namespace OpenGLRenderingEngineTests
{
  /** @brief This class encapsulates config file handling.
  * @author Thanos Theo, 2009-2018
  * @version 14.0.0.0
  */
  class OPENGL_RENDERING_ENGINE_TESTS_MODULE_API ConfigFile final
  {
  public:

    static std::string getConfigFileName();

    bool getFullScreen()                           const { return fullScreen_;                    }
    bool getMultiSample()                          const { return multiSample_;                   }
#ifdef GPU_FRAMEWORK_DEBUG
    bool getGLDebug()                              const { return glDebug_;                       }
#endif // GPU_FRAMEWORK_DEBUG
    std::size_t getTest()                          const { return test_;                          }
    std::string getTextureFileName()               const { return textureFileName_;               }
    std::string getModelFileName()                 const { return modelFileName_;                 }
    bool getUseModelLoaderDescriptor()             const { return useModelLoaderDescriptor_;      }
    std::string getModelLoaderDescriptorFileName() const { return modelLoaderDescriptorFileName_; }

    ConfigFile();
    ~ConfigFile() = default;
    ConfigFile(const ConfigFile&) = delete; // copy-constructor delete
    ConfigFile(ConfigFile&&)      = delete; // move-constructor delete
    ConfigFile& operator=(const ConfigFile&) = delete; //      assignment operator delete
    ConfigFile& operator=(ConfigFile&&)      = delete; // move-assignment operator delete

  private:

    bool fullScreen_                           = false;
    bool multiSample_                          = true;
#ifdef GPU_FRAMEWORK_DEBUG
    bool glDebug_                              = false;
#endif // GPU_FRAMEWORK_DEBUG
    std::size_t test_                          = 3;
    std::string textureFileName_               = "DotRedLogo.png";
    std::string modelFileName_                 = "dragon.obj";
    bool useModelLoaderDescriptor_             = false;
    std::string modelLoaderDescriptorFileName_ = "ModelLoaderDescriptor.tsr";

    std::string createDefaultConfigFileFromParameters() const;
    void parseParametersFromConfigFile(const std::list<std::string>& configFileLines);
  };
} // namespace OpenGLRenderingEngineTests

#endif // __ConfigFile_h