#include "OpenGLShaderSurfaceLightingLODModels.h"
#include "OpenGLAssetManager.h"
#include "OpenGLDriverInfo.h"
#include "OpenGLShaderCompileAndLink.h"
#include "OpenGLShaderGLSLPreProcessorCommands.h"
#include "OpenGLUtilityFunctions.h"

using namespace std;
using namespace OpenGLRenderingEngine;
using namespace OpenGLRenderingEngine::OpenGLUtilityFunctions;

namespace // anonymous namespace used instead of deprecated 'static' keyword used for cpp variable locality
{
  const bool USE_SPOT_LIGHTS = false;
}

OpenGLShaderSurfaceLightingLODModels::OpenGLShaderSurfaceLightingLODModels(OpenGLDriverInfo* openGLDriverInfo, bool useGeometryShader, bool applyNormalsGeometry,
                                                                           bool useOITShaders, GLuint aBuffer3DMode, GLuint aBuffer3DCounterUnit, GLuint aBuffer3DDataUnit,
                                                                           GLuint aBuffer3DLinkedListAtomicCounterUnit, GLuint aBuffer3DLinkedListOffsetUnit, GLuint aBuffer3DLinkedListUnit,
                                                                           GLuint oitUseDeferredShading) noexcept
  : OpenGLShaderProgram(openGLDriverInfo)
{
  useGeometryShader_                    = openGLDriverInfo_->supports330Shaders() && openGLDriverInfo_->supports_GL_ARB_geometry_shader4() && useGeometryShader;
  applyNormalsGeometry_                 = useGeometryShader_ && applyNormalsGeometry;
  useOITShaders_                        = openGLDriverInfo_->supports430Shaders() && useOITShaders;
  aBuffer3DMode_                        = aBuffer3DMode;
  aBuffer3DCounterUnit_                 = aBuffer3DCounterUnit;
  aBuffer3DDataUnit_                    = aBuffer3DDataUnit;
  aBuffer3DLinkedListAtomicCounterUnit_ = aBuffer3DLinkedListAtomicCounterUnit;
  aBuffer3DLinkedListOffsetUnit_        = aBuffer3DLinkedListOffsetUnit;
  aBuffer3DLinkedListUnit_              = aBuffer3DLinkedListUnit;
  oitUseDeferredShading_                = oitUseDeferredShading;

  OpenGLShaderSurfaceLightingLODModels::initializeShaderProgram();
}

void OpenGLShaderSurfaceLightingLODModels::initializeShaderProgram()
{
  GLint numberOfOuputGSVertices = openGLDriverInfo_->getMaxGeometryOutputVertices();
  if (useGeometryShader_)
  {
    numberOfOuputGSVertices = (applyNormalsGeometry_) ? 4 * 3 : 3;
  }

  openGLShaderGLSLPreProcessorCommands_->addHighestGLVersionDefinition();
  openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("GPU_VENDOR_NOT_NVIDIA",                        openGLDriverInfo_->isNvidia() ? 0 : 1);
  openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("GPU_SHADER4_COMPATIBILITY_CONDITION",          openGLDriverInfo_->supports_GL_EXT_gpu_shader4());
  openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("GPU_GEOMETRY_SHADER4_COMPATIBILITY_CONDITION", useGeometryShader_);
  openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("GPU_SHADER5_COMPATIBILITY_CONDITION",          openGLDriverInfo_->supports_GL_ARB_gpu_shader5());
  openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("APPLY_NORMALS_GEOMETRY_CONDITION",             useGeometryShader_ && applyNormalsGeometry_);
  openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("GPU_SHADER_FP64_COMPATIBILITY_CONDITION",      openGLDriverInfo_->supports_GL_ARB_gpu_shader_fp64());
  openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("USE_SPOT_LIGHTS", USE_SPOT_LIGHTS);
  openGLShaderGLSLPreProcessorCommands_->addPreprocessorLine(string("#define VS_VARYING ")    + string((openGLDriverInfo_->supports330Shaders() || openGLDriverInfo_->supports420Shaders()) ? "out" : "varying"));
  openGLShaderGLSLPreProcessorCommands_->addPreprocessorLine(string("#define FS_VARYING ")    + string((openGLDriverInfo_->supports330Shaders() || openGLDriverInfo_->supports420Shaders()) ? "in"  : "varying"));
  openGLShaderGLSLPreProcessorCommands_->addPreprocessorLine(string("#define PRECISE ")       + string(openGLDriverInfo_->supports_GL_ARB_gpu_shader5() ? "precise" : ""));
  openGLShaderGLSLPreProcessorCommands_->addPreprocessorLine(string("#define TS_GS_NORMAL ")     + string((useGeometryShader_) ? "tsGs" : "fs") + string("Normal"));
  openGLShaderGLSLPreProcessorCommands_->addPreprocessorLine(string("#define TS_FS_EYE_VECTOR ") + string((useGeometryShader_) ? "tsGs" : "fs") + string("EyeVector"));
  if (useGeometryShader_)
  {
    openGLShaderGLSLPreProcessorCommands_->addPreprocessorLine(string("#define GS_PRIMITIVE_VERTICES_IN ") + string("3"));
    openGLShaderGLSLPreProcessorCommands_->addPreprocessorLine(string("#define GS_PRIMITIVE_MAX_VERTICES_OUT ") + ((numberOfOuputGSVertices == 3) ? string("3") : string("12")));
    openGLShaderGLSLPreProcessorCommands_->addPreprocessorLine(string("#define GS_VARYING ")               + string(""));
    openGLShaderGLSLPreProcessorCommands_->addPreprocessorLine(string("#define GS_VS_NORMAL ")             + string("tsGsNormal")   );
    openGLShaderGLSLPreProcessorCommands_->addPreprocessorLine(string("#define GS_VS_EYE_VECTOR ")         + string("tsGsEyeVector"));
    openGLShaderGLSLPreProcessorCommands_->addPreprocessorLine(string("#define GS_FS_COLOR ")              + string("fsColor")      );
    openGLShaderGLSLPreProcessorCommands_->addPreprocessorLine(string("#define GS_FS_NORMAL ")             + string("fsNormal")     );
    openGLShaderGLSLPreProcessorCommands_->addPreprocessorLine(string("#define GS_FS_EYE_VECTOR ")         + string("fsEyeVector")  );
  }
  openGLShaderGLSLPreProcessorCommands_->addPreprocessorLine(string("#define FS_COLOR ")      + string("fsColor")    );
  openGLShaderGLSLPreProcessorCommands_->addPreprocessorLine(string("#define FS_NORMAL ")     + string("fsNormal")   );
  openGLShaderGLSLPreProcessorCommands_->addPreprocessorLine(string("#define FS_EYE_VECTOR ") + string("fsEyeVector"));
  openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("USE_OIT", useOITShaders_);
  if (useOITShaders_)
  {
    if ((aBuffer3DMode_ == 1) || (aBuffer3DMode_ == 2))
    {
      openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("A_BUFFER_3D_USE_TEXTURES", aBuffer3DMode_ == 1);
      openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("USE_DEFERRED_SHADING", (aBuffer3DMode_ == 2) && oitUseDeferredShading_);
      openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("ACTIVE_TEXTURE_UNIT_FOR_A_BUFFER_3D_COUNTER", aBuffer3DCounterUnit_);
      openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("ACTIVE_TEXTURE_UNIT_FOR_A_BUFFER_3D", aBuffer3DDataUnit_);
    }
    else if ((aBuffer3DMode_ == 3) || (aBuffer3DMode_ == 4))
    {
      openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("A_BUFFER_3D_USE_TEXTURES", aBuffer3DMode_ == 3);
      openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("USE_DEFERRED_SHADING", (aBuffer3DMode_ == 4) && oitUseDeferredShading_);
      openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("ACTIVE_TEXTURE_UNIT_FOR_A_BUFFER_3D_LINKED_LIST_ATOMIC_COUNTER", aBuffer3DLinkedListAtomicCounterUnit_);
      openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("ACTIVE_TEXTURE_UNIT_FOR_A_BUFFER_3D_LINKED_LIST_OFFSET", aBuffer3DLinkedListOffsetUnit_);
      openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("ACTIVE_TEXTURE_UNIT_FOR_A_BUFFER_3D_LINKED_LIST", aBuffer3DLinkedListUnit_);
    }
  }
  else
  {
    openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("USE_DEFERRED_SHADING", 0);
  }
  openGLShaderGLSLPreProcessorCommands_->addDefinitionForStartingLine();

  if (useOITShaders_)
  {
    if ((aBuffer3DMode_ == 1) || (aBuffer3DMode_ == 2))
    {
      openGLShaderCompileAndLink_->addShaderLibraryToProgram("OrderIndependentTransparency", "RenderABuffer3D", OpenGLAssetManager::FS);
    }
    else if ((aBuffer3DMode_ == 3) || (aBuffer3DMode_ == 4))
    {
      openGLShaderCompileAndLink_->addShaderLibraryToProgram("OrderIndependentTransparency", "RenderABuffer3DLinkedList", OpenGLAssetManager::FS);
    }
  }
  int lightingModelsShaderType = OpenGLAssetManager::VS | OpenGLAssetManager::TCS | OpenGLAssetManager::TES | OpenGLAssetManager::FS;
  if (useGeometryShader_)
  {
    lightingModelsShaderType |= OpenGLAssetManager::GS;
    openGLShaderCompileAndLink_->addShaderLibraryToProgram("CommonFunctions", "CommonFunctions",                        lightingModelsShaderType);
    openGLShaderCompileAndLink_->addShaderLibraryToProgram("SurfaceLightingModels", "SurfaceLightingModels",            OpenGLAssetManager::FS);
    openGLShaderCompileAndLink_->addShaderLibraryToProgram("SurfaceLightingLODModels", "ApplySurfaceLightingLODModels", lightingModelsShaderType);
    openGLShaderCompileAndLink_->linkShaderProgram(GL_TRIANGLES, GL_TRIANGLE_STRIP, numberOfOuputGSVertices);
  }
  else
  {
    openGLShaderCompileAndLink_->addShaderLibraryToProgram("CommonFunctions", "CommonFunctions",                        lightingModelsShaderType);
    openGLShaderCompileAndLink_->addShaderLibraryToProgram("SurfaceLightingModels", "SurfaceLightingModels",            OpenGLAssetManager::FS);
    openGLShaderCompileAndLink_->addShaderLibraryToProgram("SurfaceLightingLODModels", "ApplySurfaceLightingLODModels", lightingModelsShaderType);
    openGLShaderCompileAndLink_->linkShaderProgram();
  }

  GLAuxiliaryFunctions_checkGLError();
}

void OpenGLShaderSurfaceLightingLODModels::useProgramAndUniforms(GLint LODModel, GLfloat tessellationAlpha, GLfloat tessellationLevel, GLint useAdaptiveTessellation,
                                                                 GLint useTrianglePositionAdaptiveTessellationMetric, GLint useLightAdaptiveTessellationMetric, GLint useContourAdaptiveTessellationMetric,
                                                                 GLint numberOfLights, GLint lightingModel, GLint useOrenNayarDiffuseModel, GLint useFresnelFactorSchlickApproximationSpecularModel, GLint useColorMaterial, GLfloat sceneScaleFactor, GLint shrinkTriangles, GLint normals,
                                                                 GLint texturing, GLuint activeTextureUnitFor2DTexture, GLint sphericalMapping, GLint environmentMapping,
                                                                 GLint enforceColor, GLint blackOrWhite, GLint fog, GLint gammaCorrection, GLfloat opacity, GLfloat timer,
                                                                 GLint useGBuffer,
                                                                 GLint screenWidth, GLint screenHeight, GLint aBuffer3DSize, GLint useOwnPackingMethodsForScreenshots)
{
  enableShaderProgram();

  setUniform1i("LODModel", LODModel);
  setUniform1f("tessellationAlpha", tessellationAlpha);
  setUniform1f("tessellationLevel", tessellationLevel);
  setUniform1i("useAdaptiveTessellation", useAdaptiveTessellation);
  setUniform1i("useTrianglePositionAdaptiveTessellationMetric", useTrianglePositionAdaptiveTessellationMetric);
  setUniform1i("useLightAdaptiveTessellationMetric", useLightAdaptiveTessellationMetric);
  setUniform1i("useContourAdaptiveTessellationMetric", useContourAdaptiveTessellationMetric);
  setUniform1i("numberOfLights", numberOfLights);
  setUniform1i("lightingModel", lightingModel);
  setUniform1i("useOrenNayarDiffuseModel", useOrenNayarDiffuseModel);
  setUniform1i("useFresnelFactorSchlickApproximationSpecularModel", useFresnelFactorSchlickApproximationSpecularModel);
  setUniform1i("useColorMaterial", useColorMaterial);
  setUniform1f("extraGaussianSpecularFactor", 1.0f);
  setUniform1f("sceneScaleFactor", sceneScaleFactor);
  setUniform1i("shrinkTriangles", shrinkTriangles);
  setUniform1i("normals", normals);
  setUniform1i("texturing", texturing);
  if (texturing)
  {
    setUniform1i("texture", activeTextureUnitFor2DTexture);
    setUniform1i("sphericalMapping", sphericalMapping);
    setUniform1i("texturingMode", GLAuxiliaryFunctions::convertTexEnvModeGLConstantToShaderEnum((sphericalMapping && environmentMapping) ? GL_MODULATE : GL_DECAL));
    setUniform1i("environmentMapping", environmentMapping);
  }
  setUniform1i("enforceColor", enforceColor);
  setUniform1i("blackOrWhite", blackOrWhite);
  setUniform1i("fog", fog);
  setUniform1i("gammaCorrection", gammaCorrection);
  setUniform1f("opacity", opacity);
  setUniform1f("timer", timer);
  setUniform1i("useGBuffer", useGBuffer);
  if (useOITShaders_)
  {
    setUniform1i("screenWidth", screenWidth);
    setUniform1i("screenHeight", screenHeight);
    setUniform1i("aBuffer3DSize", aBuffer3DSize);
    setUniform1i("useOwnPackingMethodsForScreenshots", useOwnPackingMethodsForScreenshots);
  }

  GLAuxiliaryFunctions_checkGLError();
}