#include "OpenGLShaderObjects.h"
#include "UtilityFunctions.h"

using namespace std;
using namespace OpenGLRenderingEngine;

OpenGLShaderObjects::OpenGLShaderObjects(int shaderType) noexcept
{
  shaderType_ = new bitset<OpenGLAssetManager::NUMBER_OF_TOTAL_SHADER_TYPES>(shaderType);
}

OpenGLShaderObjects::~OpenGLShaderObjects() noexcept
{
  delete shaderType_;
  shaderType_ = nullptr;
}

void OpenGLShaderObjects::attachShaderObjectsToProgram(GLuint shaderProgram)
{
  if (glIsProgram(shaderProgram))
  {
    for (auto& shaderObject : shaderObjects_)
    {
      if (shaderObject)
      {
        glAttachShader(shaderProgram, shaderObject);
      }
    }
  }
  else
  {
    DebugConsole_consoleOutLine("Attach Shader Error: Shader objects were attempted to be attached to a non-valid shader program!");
  }
}

void OpenGLShaderObjects::detachShaderObjectsFromProgram(GLuint shaderProgram)
{
  if (glIsProgram(shaderProgram))
  {
    for (auto& shaderObject : shaderObjects_)
    {
      if (shaderObject)
      {
        glDetachShader(shaderProgram, shaderObject);
      }
    }
  }
  else
  {
    DebugConsole_consoleOutLine("Detach Shader Error: Shader objects were attempted to be detached from a non-valid shader program!");
  }
}

size_t OpenGLShaderObjects::numberOfCreatedShaderObjects() const
{
  size_t createdShaderObjects = 0;
  for (const auto& shaderObject : shaderObjects_)
  {
    if (shaderObject)
    {
      ++createdShaderObjects;
    }
  }

  return createdShaderObjects;
}
