#include "OpenGLShaderImpostorModels.h"
#include "OpenGLAssetManager.h"
#include "OpenGLDriverInfo.h"
#include "OpenGLShaderCompileAndLink.h"
#include "OpenGLShaderGLSLPreProcessorCommands.h"
#include "OpenGLUtilityFunctions.h"

using namespace std;
using namespace OpenGLRenderingEngine;
using namespace OpenGLRenderingEngine::OpenGLUtilityFunctions;

OpenGLShaderImpostorModels::OpenGLShaderImpostorModels(OpenGLDriverInfo* openGLDriverInfo, bool isQuadSphereModel, bool useGeometryShader, bool useTessellationShader, bool useTessellationQuadShader, bool useCylinderImpostor, bool useFP64,
                                                             bool useOITShaders, GLuint aBuffer3DMode, GLuint aBuffer3DCounterUnit, GLuint aBuffer3DDataUnit,
                                                             GLuint aBuffer3DLinkedListAtomicCounterUnit, GLuint aBuffer3DLinkedListOffsetUnit, GLuint aBuffer3DLinkedListUnit,
                                                             GLuint oitUseDeferredShading) noexcept
  : OpenGLShaderProgram(openGLDriverInfo, false) // disable two-sided lighting vertex program for Point Sphere Model shaders to get a speed-boost
  , isQuadSphereModel_(isQuadSphereModel)
  , useTessellationQuadShader_(useTessellationQuadShader)
{
  useGeometryShader_                    = openGLDriverInfo_->supports330Shaders() && openGLDriverInfo_->supports_GL_ARB_geometry_shader4()                                    && isQuadSphereModel && useGeometryShader;
  useTessellationShader_                = openGLDriverInfo_->supports420Shaders() && openGLDriverInfo_->supports_GL_ARB_tessellation_shader() && !openGLDriverInfo->isIntel() && isQuadSphereModel && useTessellationShader && !useCylinderImpostor;
  useCylinderImpostor_                  = openGLDriverInfo_->supports330Shaders() && openGLDriverInfo_->supports_GL_ARB_geometry_shader4()                                                         && useGeometryShader     &&  useCylinderImpostor;
  useFP64_                              = openGLDriverInfo_->supports430Shaders() && openGLDriverInfo_->supports_GL_ARB_gpu_shader_fp64() && useFP64;
  useOITShaders_                        = openGLDriverInfo_->supports430Shaders() && useOITShaders;
  aBuffer3DMode_                        = aBuffer3DMode;
  aBuffer3DCounterUnit_                 = aBuffer3DCounterUnit;
  aBuffer3DDataUnit_                    = aBuffer3DDataUnit;
  aBuffer3DLinkedListAtomicCounterUnit_ = aBuffer3DLinkedListAtomicCounterUnit;
  aBuffer3DLinkedListOffsetUnit_        = aBuffer3DLinkedListOffsetUnit;
  aBuffer3DLinkedListUnit_              = aBuffer3DLinkedListUnit;
  oitUseDeferredShading_                = oitUseDeferredShading;

  OpenGLShaderImpostorModels::initializeShaderProgram();
}

void OpenGLShaderImpostorModels::initializeShaderProgram()
{
  if (useTessellationShader_)
  {
    openGLShaderGLSLPreProcessorCommands_->addHighestGLVersionDefinition();
    openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("USE_SPOT_LIGHTS", 0);
    openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("GPU_SHADER4_COMPATIBILITY_CONDITION", openGLDriverInfo_->supports_GL_EXT_gpu_shader4());
    openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("GPU_SHADER5_COMPATIBILITY_CONDITION", openGLDriverInfo_->supports_GL_ARB_gpu_shader5());
    if (useTessellationQuadShader_)
    {
      openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("GPU_SHADER_FP64_COMPATIBILITY_CONDITION", openGLDriverInfo_->isNvidia() && useFP64_);
    }
    openGLShaderGLSLPreProcessorCommands_->addPreprocessorLine(string("#define VS_VARYING ") + string((openGLDriverInfo_->supports330Shaders() || openGLDriverInfo_->supports420Shaders()) ? "out" : "varying"));
    openGLShaderGLSLPreProcessorCommands_->addPreprocessorLine(string("#define FS_VARYING ") + string((openGLDriverInfo_->supports330Shaders() || openGLDriverInfo_->supports420Shaders()) ? "in"  : "varying"));
    openGLShaderGLSLPreProcessorCommands_->addPreprocessorLine(string("#define PRECISE ") + string(openGLDriverInfo_->supports_GL_ARB_gpu_shader5() ? "precise" : ""));
    openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("USE_OIT", useOITShaders_);
    if (useOITShaders_)
    {
      if ((aBuffer3DMode_ == 1) || (aBuffer3DMode_ == 2))
      {
        openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("A_BUFFER_3D_USE_TEXTURES", aBuffer3DMode_ == 1);
        openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("USE_DEFERRED_SHADING", (aBuffer3DMode_ == 2) && oitUseDeferredShading_);
        openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("ACTIVE_TEXTURE_UNIT_FOR_A_BUFFER_3D_COUNTER", aBuffer3DCounterUnit_);
        openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("ACTIVE_TEXTURE_UNIT_FOR_A_BUFFER_3D", aBuffer3DDataUnit_);
      }
      else if ((aBuffer3DMode_ == 3) || (aBuffer3DMode_ == 4))
      {
        openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("A_BUFFER_3D_USE_TEXTURES", aBuffer3DMode_ == 3);
        openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("USE_DEFERRED_SHADING", (aBuffer3DMode_ == 4) && oitUseDeferredShading_);
        openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("ACTIVE_TEXTURE_UNIT_FOR_A_BUFFER_3D_LINKED_LIST_ATOMIC_COUNTER", aBuffer3DLinkedListAtomicCounterUnit_);
        openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("ACTIVE_TEXTURE_UNIT_FOR_A_BUFFER_3D_LINKED_LIST_OFFSET", aBuffer3DLinkedListOffsetUnit_);
        openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("ACTIVE_TEXTURE_UNIT_FOR_A_BUFFER_3D_LINKED_LIST", aBuffer3DLinkedListUnit_);
      }
    }
    else
    {
      openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("USE_DEFERRED_SHADING", 0);
    }
    openGLShaderGLSLPreProcessorCommands_->addDefinitionForStartingLine();

    if (useOITShaders_)
    {
      if ((aBuffer3DMode_ == 1) || (aBuffer3DMode_ == 2))
      {
        openGLShaderCompileAndLink_->addShaderLibraryToProgram("OrderIndependentTransparency", "RenderABuffer3D", OpenGLAssetManager::FS);
      }
      else if ((aBuffer3DMode_ == 3) || (aBuffer3DMode_ == 4))
      {
        openGLShaderCompileAndLink_->addShaderLibraryToProgram("OrderIndependentTransparency", "RenderABuffer3DLinkedList", OpenGLAssetManager::FS);
      }
    }
    const int impostorModelsShaderType = OpenGLAssetManager::VS | OpenGLAssetManager::TCS | OpenGLAssetManager::TES | OpenGLAssetManager::FS;
    openGLShaderCompileAndLink_->addShaderLibraryToProgram("CommonFunctions", "CommonFunctions",               impostorModelsShaderType);
    openGLShaderCompileAndLink_->addShaderLibraryToProgram("SurfaceLightingModels", "SurfaceLightingModels", OpenGLAssetManager::FS);
    if (useTessellationQuadShader_)
    {
      openGLShaderCompileAndLink_->addShaderLibraryToProgram("PointSphereTessQuadModels", "ApplyPointSphereTessQuadModel", impostorModelsShaderType);
    }
    else
    {
      openGLShaderCompileAndLink_->addShaderLibraryToProgram("PointSphereTessLODModels", "ApplyPointSphereTessLODModel", impostorModelsShaderType);
    }
    openGLShaderCompileAndLink_->linkShaderProgram();
  }
  else
  {
    if (openGLDriverInfo_->supports330Shaders()) // use advanced lighting models on good GPU hardware
    {
      openGLShaderGLSLPreProcessorCommands_->addHighestGLVersionDefinition();
      openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("APPLY_SURFACE_LIGHTING_MODELS", 1);
      openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("USE_SPOT_LIGHTS", 0);
      openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("GPU_SHADER4_COMPATIBILITY_CONDITION", openGLDriverInfo_->supports_GL_EXT_gpu_shader4());
      openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("GPU_SHADER5_COMPATIBILITY_CONDITION", openGLDriverInfo_->supports_GL_ARB_gpu_shader5());
      if (isQuadSphereModel_ || useCylinderImpostor_)
      {
        openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("GPU_VENDOR_NOT_NVIDIA",                        openGLDriverInfo_->isNvidia() ? 0 : 1);
        openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("GPU_GEOMETRY_SHADER4_COMPATIBILITY_CONDITION", useGeometryShader_);
        openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("GPU_SHADER_FP64_COMPATIBILITY_CONDITION", openGLDriverInfo_->isNvidia() && useFP64_);
      }
    }
    else // for lesser GPU hardware (GL 2.1 compliant only), use simple Phong lighting model
    {
      openGLShaderGLSLPreProcessorCommands_->addGL21VersionDefinition();
      openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("GPU_SHADER4_COMPATIBILITY_CONDITION", 0);
      openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("GPU_SHADER5_COMPATIBILITY_CONDITION", 0);
      openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("APPLY_SURFACE_LIGHTING_MODELS", 0);
    }

    openGLShaderGLSLPreProcessorCommands_->addPreprocessorLine(string("#define VS_VARYING ") + string((openGLDriverInfo_->supports330Shaders() || openGLDriverInfo_->supports420Shaders()) ? "out" : "varying"));
    openGLShaderGLSLPreProcessorCommands_->addPreprocessorLine(string("#define FS_VARYING ") + string((openGLDriverInfo_->supports330Shaders() || openGLDriverInfo_->supports420Shaders()) ? "in" : "varying"));
    if (isQuadSphereModel_)
    {
      openGLShaderGLSLPreProcessorCommands_->addPreprocessorLine(string("#define VS_SPHERE_RADIUS ") + string((useGeometryShader_) ? "vs" : "") + string("SphereRadius"));
      openGLShaderGLSLPreProcessorCommands_->addPreprocessorLine(string("#define VS_SPHERE_COLOR ") + string((useGeometryShader_) ? "vs" : "") + string("SphereColor"));
      if (!useGeometryShader_)
      {
        openGLShaderGLSLPreProcessorCommands_->addPreprocessorLine(string("#define VS_SPHERE_CIRCULAR_FACTOR ") + string((useGeometryShader_) ? "vs" : "") + string("SphereCircularFactor"));
        openGLShaderGLSLPreProcessorCommands_->addPreprocessorLine(string("#define VS_MAPPING ") + string((useGeometryShader_) ? "vs" : "") + string("Mapping"));
        openGLShaderGLSLPreProcessorCommands_->addPreprocessorLine(string("#define VS_CAMERA_SPHERE_POSITION ") + string((useGeometryShader_) ? "vs" : "") + string("CameraSpherePosition"));
      }
      if (useGeometryShader_)
      {
        openGLShaderGLSLPreProcessorCommands_->addPreprocessorLine(string("#define GS_PRIMITIVE_VERTICES_IN ") + string("1"));
        openGLShaderGLSLPreProcessorCommands_->addPreprocessorLine(string("#define GS_VARYING ") + string(""));
        openGLShaderGLSLPreProcessorCommands_->addPreprocessorLine(string("#define GS_VS_SPHERE_RADIUS ") + string("vsSphereRadius"));
        openGLShaderGLSLPreProcessorCommands_->addPreprocessorLine(string("#define GS_VS_SPHERE_COLOR ") + string("vsSphereColor"));
        openGLShaderGLSLPreProcessorCommands_->addPreprocessorLine(string("#define GS_FS_SPHERE_RADIUS ") + string("fsSphereRadius"));
        openGLShaderGLSLPreProcessorCommands_->addPreprocessorLine(string("#define GS_FS_SPHERE_CIRCULAR_FACTOR ") + string("fsSphereCircularFactor"));
        openGLShaderGLSLPreProcessorCommands_->addPreprocessorLine(string("#define GS_FS_SPHERE_COLOR ") + string("fsSphereColor"));
        openGLShaderGLSLPreProcessorCommands_->addPreprocessorLine(string("#define GS_FS_MAPPING ") + string("fsMapping"));
        openGLShaderGLSLPreProcessorCommands_->addPreprocessorLine(string("#define GS_FS_CAMERA_SPHERE_POSITION ") + string("fsCameraSpherePosition"));
      }
      openGLShaderGLSLPreProcessorCommands_->addPreprocessorLine(string("#define FS_SPHERE_RADIUS ") + string((useGeometryShader_) ? "fs" : "") + string("SphereRadius"));
      openGLShaderGLSLPreProcessorCommands_->addPreprocessorLine(string("#define FS_SPHERE_CIRCULAR_FACTOR ") + string((useGeometryShader_) ? "fs" : "") + string("SphereCircularFactor"));
      openGLShaderGLSLPreProcessorCommands_->addPreprocessorLine(string("#define FS_SPHERE_COLOR ") + string((useGeometryShader_) ? "fs" : "") + string("SphereColor"));
      openGLShaderGLSLPreProcessorCommands_->addPreprocessorLine(string("#define FS_MAPPING ") + string((useGeometryShader_) ? "fs" : "") + string("Mapping"));
      openGLShaderGLSLPreProcessorCommands_->addPreprocessorLine(string("#define FS_CAMERA_SPHERE_POSITION ") + string((useGeometryShader_) ? "fs" : "") + string("CameraSpherePosition"));
    }

    openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("USE_OIT", useOITShaders_);
    if (useOITShaders_)
    {
      if ((aBuffer3DMode_ == 1) || (aBuffer3DMode_ == 2))
      {
        openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("A_BUFFER_3D_USE_TEXTURES", aBuffer3DMode_ == 1);
        openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("USE_DEFERRED_SHADING", (aBuffer3DMode_ == 2) && oitUseDeferredShading_);
        openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("ACTIVE_TEXTURE_UNIT_FOR_A_BUFFER_3D_COUNTER", aBuffer3DCounterUnit_);
        openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("ACTIVE_TEXTURE_UNIT_FOR_A_BUFFER_3D", aBuffer3DDataUnit_);
      }
      else if ((aBuffer3DMode_ == 3) || (aBuffer3DMode_ == 4))
      {
        openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("A_BUFFER_3D_USE_TEXTURES", aBuffer3DMode_ == 3);
        openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("USE_DEFERRED_SHADING", (aBuffer3DMode_ == 4) && oitUseDeferredShading_);
        openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("ACTIVE_TEXTURE_UNIT_FOR_A_BUFFER_3D_LINKED_LIST_ATOMIC_COUNTER", aBuffer3DLinkedListAtomicCounterUnit_);
        openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("ACTIVE_TEXTURE_UNIT_FOR_A_BUFFER_3D_LINKED_LIST_OFFSET", aBuffer3DLinkedListOffsetUnit_);
        openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("ACTIVE_TEXTURE_UNIT_FOR_A_BUFFER_3D_LINKED_LIST", aBuffer3DLinkedListUnit_);
      }
    }
    else
    {
      openGLShaderGLSLPreProcessorCommands_->addDefinitionAndCondition("USE_DEFERRED_SHADING", 0);
    }
    openGLShaderGLSLPreProcessorCommands_->addDefinitionForStartingLine();

    if (useOITShaders_)
    {
      if ((aBuffer3DMode_ == 1) || (aBuffer3DMode_ == 2))
      {
        openGLShaderCompileAndLink_->addShaderLibraryToProgram("OrderIndependentTransparency", "RenderABuffer3D", OpenGLAssetManager::FS);
      }
      else if ((aBuffer3DMode_ == 3) || (aBuffer3DMode_ == 4))
      {
        openGLShaderCompileAndLink_->addShaderLibraryToProgram("OrderIndependentTransparency", "RenderABuffer3DLinkedList", OpenGLAssetManager::FS);
      }
    }
    int commonFunctionShaderType = OpenGLAssetManager::VS | OpenGLAssetManager::FS; // add VS for cylinder glsl case
    if (useGeometryShader_)
    {
      commonFunctionShaderType |= OpenGLAssetManager::GS;
    }
    openGLShaderCompileAndLink_->addShaderLibraryToProgram("CommonFunctions", "CommonFunctions",                         commonFunctionShaderType);
    if (openGLDriverInfo_->supports330Shaders()) // use advanced lighting models on good GPU hardware
    {
      openGLShaderCompileAndLink_->addShaderLibraryToProgram("SurfaceLightingModels", "SurfaceLightingModels", OpenGLAssetManager::FS);
    }
    else // if (openGLDriverInfo->supports120Shaders()) // for lesser GPU hardware (GL 2.1 compliant only), use simple Phong lighting model
    {
      openGLShaderCompileAndLink_->addShaderLibraryToProgram("SurfaceLightingModels", "SurfaceSimplePhongLightingModel", OpenGLAssetManager::FS);
    }
    int impostorModelsShaderType = OpenGLAssetManager::VS | OpenGLAssetManager::FS;
    if (useGeometryShader_)
    {
      impostorModelsShaderType |= OpenGLAssetManager::GS;
    }
    if (useCylinderImpostor_)
    {
      openGLShaderCompileAndLink_->addShaderLibraryToProgram("PointCylinderModels", "ApplyCylinderModel", impostorModelsShaderType);
    }
    else
    {
      openGLShaderCompileAndLink_->addShaderLibraryToProgram("PointSphereModels", isQuadSphereModel_ ? "ApplyQuadSphereModel" : "ApplyPointSphereModel", impostorModelsShaderType);
    }
    if (useGeometryShader_)
    {
      openGLShaderCompileAndLink_->linkShaderProgram(GL_POINTS, GL_TRIANGLE_STRIP, useCylinderImpostor_ ? 6 : 4);
    }
    else
    {
      openGLShaderCompileAndLink_->linkShaderProgram();
    }
  }

  GLAuxiliaryFunctions_checkGLError();
}

void OpenGLShaderImpostorModels::useProgramAndUniforms(GLint numberOfLights, GLint lightingModel, GLint useOrenNayarDiffuseModel, GLint useColorMaterial, GLfloat sceneScaleFactor,
                                                          GLint width, GLint height, GLfloat radiusFactor, GLint pointAntialias, GLint perspectiveCorrection,
                                                          GLint texturing, GLuint activeTextureUnitFor2DTexture, GLint sphericalMapping, GLint environmentMapping,
                                                          GLint fog, GLint gammaCorrection, GLfloat opacity,
                                                          GLint useGBuffer,
                                                          GLint screenWidth, GLint screenHeight, GLint aBuffer3DSize, GLint useOwnPackingMethodsForScreenshots,
                                                          GLint useRandomlyGeneratedCylinderVariables, GLfloat cylinderRadius)
{
  enableShaderProgram();

  setUniform1i("numberOfLights", numberOfLights);
  setUniform1i("lightingModel", lightingModel);
  setUniform1i("useOrenNayarDiffuseModel", useOrenNayarDiffuseModel);
  setUniform1i("useFresnelFactorSchlickApproximationSpecularModel", false);
  setUniform1i("useColorMaterial", useColorMaterial);
  setUniform1f("extraGaussianSpecularFactor", 1.0f);
  setUniform1f("sceneScaleFactor", sceneScaleFactor);
  const float vpSizeAndOrigin[4] = { float(width), float(height), 0.0f, 0.0f };
  setUniform4fv("vpSizeAndOrigin", 1, vpSizeAndOrigin);
  setUniform1i("variablePointSphereRadius", true);
  setUniform1f("pointSphereDiameterWithTiling", 2.0f * radiusFactor);
  setUniform1f("radiusFactor", 1.0f + radiusFactor / 2.0f);
  setUniform1i("pointAntialias", pointAntialias);
  setUniform1i("perspectiveCorrection", perspectiveCorrection);
  setUniform1f("windowRatio", float(width) / float(height));
  setUniform1i("texturing", texturing);
  if (texturing)
  {
    setUniform1i("texture", activeTextureUnitFor2DTexture);
    setUniform1i("sphericalMapping", sphericalMapping);
    setUniform1i("texturingMode", GLAuxiliaryFunctions::convertTexEnvModeGLConstantToShaderEnum((sphericalMapping && environmentMapping) ? GL_MODULATE : GL_DECAL));
    setUniform1i("environmentMapping", environmentMapping);
  }
  setUniform1i("fog", fog);
  setUniform1i("gammaCorrection", gammaCorrection);
  setUniform1f("opacity", opacity);
  setUniform1i("useGBuffer", useGBuffer);
  if (useOITShaders_)
  {
    setUniform1i("screenWidth", screenWidth);
    setUniform1i("screenHeight", screenHeight);
    setUniform1i("aBuffer3DSize", aBuffer3DSize);
    setUniform1i("useOwnPackingMethodsForScreenshots", useOwnPackingMethodsForScreenshots);
  }
  setUniform1i("useRandomlyGeneratedCylinderVariables", useRandomlyGeneratedCylinderVariables);
  setUniform1f("cylinderRadius", cylinderRadius);

  GLAuxiliaryFunctions_checkGLError();
}