#include "OpenGLShaderGLSLPreProcessorCommands.h"
#include "OpenGLDriverInfo.h"
#include <iostream>

using namespace std;
using namespace OpenGLRenderingEngine;

OpenGLShaderGLSLPreProcessorCommands::OpenGLShaderGLSLPreProcessorCommands(OpenGLDriverInfo* openGLDriverInfo) noexcept
  : openGLDriverInfo_(openGLDriverInfo)
{
  clearGLSLPreProcessorCommands();
}

OpenGLShaderGLSLPreProcessorCommands::~OpenGLShaderGLSLPreProcessorCommands() noexcept
{
  clearGLSLPreProcessorCommands();
}

void OpenGLShaderGLSLPreProcessorCommands::addHighestGLVersionDefinition()
{
  const string GLSLPreProcessorCommandsString = allGLSLPreProcessorCommands_.str();
  if (string::npos == GLSLPreProcessorCommandsString.find("#version"))
  {
    if (openGLDriverInfo_->supports450Shaders())
    {
      addGL45VersionDefinition();
    }
    else if (openGLDriverInfo_->supports440Shaders())
    {
      addGL44VersionDefinition();
    }
    else if (openGLDriverInfo_->supports430Shaders())
    {
      addGL43VersionDefinition();
    }
    else if (openGLDriverInfo_->supports420Shaders())
    {
      addGL42VersionDefinition();
    }
    else if (openGLDriverInfo_->supports330Shaders())
    {
      addGL33VersionDefinition();
    }
    else // if (_openGLDriverInfo->supports120Shaders())
    {
      addGL21VersionDefinition();
    }
  }
}

void OpenGLShaderGLSLPreProcessorCommands::addGL21VersionDefinition()
{
  const string GLSLPreProcessorCommandsString = allGLSLPreProcessorCommands_.str();
  if (string::npos == GLSLPreProcessorCommandsString.find("#version"))
  {
    const string versionString = OpenGLDriverInfo::getMinimumGLSLVersionFor120Shaders();
    allGLSLPreProcessorCommands_ << "#version " << versionString << endl;
  }
}

void OpenGLShaderGLSLPreProcessorCommands::addGL33VersionDefinition()
{
  const string GLSLPreProcessorCommandsString = allGLSLPreProcessorCommands_.str();
  if (string::npos == GLSLPreProcessorCommandsString.find("#version"))
  {
    const string versionString = OpenGLDriverInfo::getMinimumGLSLVersionFor330Shaders() + " " + OpenGLDriverInfo::getGLSLLanguageMode();
    allGLSLPreProcessorCommands_ << "#version " << versionString << endl;
  }
}

void OpenGLShaderGLSLPreProcessorCommands::addGL42VersionDefinition()
{
  const string GLSLPreProcessorCommandsString = allGLSLPreProcessorCommands_.str();
  if (string::npos == GLSLPreProcessorCommandsString.find("#version"))
  {
    const string versionString = OpenGLDriverInfo::getMinimumGLSLVersionFor420Shaders() + " " + OpenGLDriverInfo::getGLSLLanguageMode();
    allGLSLPreProcessorCommands_ << "#version " << versionString << endl;
  }
}

void OpenGLShaderGLSLPreProcessorCommands::addGL43VersionDefinition()
{
  const string GLSLPreProcessorCommandsString = allGLSLPreProcessorCommands_.str();
  if (string::npos == GLSLPreProcessorCommandsString.find("#version"))
  {
    const string versionString = OpenGLDriverInfo::getMinimumGLSLVersionFor430Shaders() + " " + OpenGLDriverInfo::getGLSLLanguageMode();
    allGLSLPreProcessorCommands_ << "#version " << versionString << endl;
  }
}

void OpenGLShaderGLSLPreProcessorCommands::addGL44VersionDefinition()
{
  const string GLSLPreProcessorCommandsString = allGLSLPreProcessorCommands_.str();
  if (string::npos == GLSLPreProcessorCommandsString.find("#version"))
  {
    const string versionString = OpenGLDriverInfo::getMinimumGLSLVersionFor440Shaders() + " " + OpenGLDriverInfo::getGLSLLanguageMode();
    allGLSLPreProcessorCommands_ << "#version " << versionString << endl;
  }
}

void OpenGLShaderGLSLPreProcessorCommands::addGL45VersionDefinition()
{
  const string GLSLPreProcessorCommandsString = allGLSLPreProcessorCommands_.str();
  if (string::npos == GLSLPreProcessorCommandsString.find("#version"))
  {
    const string versionString = OpenGLDriverInfo::getMinimumGLSLVersionFor450Shaders() + " " + OpenGLDriverInfo::getGLSLLanguageMode();
    allGLSLPreProcessorCommands_ << "#version " << versionString << endl;
  }
}

void OpenGLShaderGLSLPreProcessorCommands::addDefinition(const string& definition)
{
  allGLSLPreProcessorCommands_ << "#define " << definition << endl;
}

void OpenGLShaderGLSLPreProcessorCommands::addDefinitionAndCondition(const string& definition, int condition)
{
  allGLSLPreProcessorCommands_ << "#define " << definition << " " << condition << endl;
}

void OpenGLShaderGLSLPreProcessorCommands::addPreprocessorLine(const string& GLSLPreProcessorLine)
{
  allGLSLPreProcessorCommands_ << GLSLPreProcessorLine << endl;
}

void OpenGLShaderGLSLPreProcessorCommands::addDefinitionForStartingLine()
{
  // define new starting line 1 here, after all added GLSL preprocessor commands
  allGLSLPreProcessorCommands_ << "#line 1" << endl;
}

string OpenGLShaderGLSLPreProcessorCommands::getFinalizedGLSLPreProcessorCommands()
{
  const string GLSLPreProcessorCommandsString = allGLSLPreProcessorCommands_.str();
  if (string::npos != GLSLPreProcessorCommandsString.find("#line 1"))
  {
    return GLSLPreProcessorCommandsString;
  }

  addDefinitionForStartingLine();

  return allGLSLPreProcessorCommands_.str();
}

void OpenGLShaderGLSLPreProcessorCommands::clearGLSLPreProcessorCommands()
{
  // clear buffer
  allGLSLPreProcessorCommands_.str("");
  allGLSLPreProcessorCommands_.clear();
}