#include "OpenGLModelAmbientLight.h"

using namespace OpenGLRenderingEngine;

OpenGLModelAmbientLight::OpenGLModelAmbientLight() noexcept
{
 modelAmbientColor_[0] = 0.2f;
 modelAmbientColor_[1] = 0.2f;
 modelAmbientColor_[2] = 0.2f;
 modelAmbientColor_[3] = 1.0f;
}

void OpenGLModelAmbientLight::setModelAmbientColor(float r, float g, float b, float a)
{
  modelAmbientColor_[0] = r;
  modelAmbientColor_[1] = g;
  modelAmbientColor_[2] = b;
  modelAmbientColor_[3] = a;
}

void OpenGLModelAmbientLight::setModelAmbientColor(const float modelAmbientColor[4])
{
  setModelAmbientColor(modelAmbientColor[0], modelAmbientColor[1], modelAmbientColor[2], modelAmbientColor[3]);
}

void OpenGLModelAmbientLight::enable(int lightId, bool usePositionalLight)
{
  glLightModelfv(GL_LIGHT_MODEL_AMBIENT, modelAmbientColor_);
}

void OpenGLModelAmbientLight::update(int lightId, bool usePositionalLight, float updateX, float updateY, float updateZ)
{
  // nothing to update for model ambient light
}

void OpenGLModelAmbientLight::disable() const
{
  // nothing to disable for model ambient light
}