#include "OpenGLMaterial.h"

using namespace OpenGLRenderingEngine;

OpenGLMaterial::OpenGLMaterial(bool useColorMaterial) noexcept
  : useColorMaterial_(useColorMaterial)
{
 ambientColor_[0] = 0.2f;
 ambientColor_[1] = 0.2f;
 ambientColor_[2] = 0.2f;
 ambientColor_[3] = 1.0f;

 diffuseColor_[0] = 1.0f;
 diffuseColor_[1] = 1.0f;
 diffuseColor_[2] = 1.0f;
 diffuseColor_[3] = 1.0f;

 specularColor_[0] = 0.0f;
 specularColor_[1] = 0.0f;
 specularColor_[2] = 0.0f;
 specularColor_[3] = 1.0f;
}

void OpenGLMaterial::setAmbientColor(float r, float g, float b, float a)
{
  ambientColor_[0] = r;
  ambientColor_[1] = g;
  ambientColor_[2] = b;
  ambientColor_[3] = a;
}

void OpenGLMaterial::setAmbientColor(const float ambientColor[4])
{
  setAmbientColor(ambientColor[0], ambientColor[1], ambientColor[2], ambientColor[3]);
}

void OpenGLMaterial::setDiffuseColor(float r, float g, float b, float a)
{
  diffuseColor_[0] = r;
  diffuseColor_[1] = g;
  diffuseColor_[2] = b;
  diffuseColor_[3] = a;
}

void OpenGLMaterial::setDiffuseColor(const float diffuseColor[4])
{
  setDiffuseColor(diffuseColor[0], diffuseColor[1], diffuseColor[2], diffuseColor[3]);
}

void OpenGLMaterial::setSpecularColor(float r, float g, float b, float a)
{
  specularColor_[0] = r;
  specularColor_[1] = g;
  specularColor_[2] = b;
  specularColor_[3] = a;
}

void OpenGLMaterial::setSpecularColor(const float specularColor[4])
{
  setSpecularColor(specularColor[0], specularColor[1], specularColor[2], specularColor[3]);
}

void OpenGLMaterial::enable(int lightId, bool usePositionalLight)
{
  if (useColorMaterial_)
  {
    glEnable(GL_COLOR_MATERIAL);
    glColorMaterial(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE);
  }
  else
  {
    glDisable(GL_COLOR_MATERIAL);
    glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT, ambientColor_);
    glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE, diffuseColor_);
  }

  glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, specularColor_);
  glMaterialf(GL_FRONT_AND_BACK, GL_SHININESS, shininess_);
}

void OpenGLMaterial::update(int lightId, bool usePositionalLight, float updateX, float updateY, float updateZ)
{
  // nothing to update for material
}

void OpenGLMaterial::disable() const
{
  glDisable(GL_COLOR_MATERIAL);
}