#include "OpenGLLookAtCamera.h"
#include "glew.h"

using namespace OpenGLRenderingEngine;

OpenGLLookAtCamera::OpenGLLookAtCamera(float fieldOfView) noexcept
  : OpenGLCameraAbstractBase(fieldOfView)
{
}

void OpenGLLookAtCamera::setMatrices() const
{
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluPerspective(fieldOfView_, ratio_, viewNear_, viewFar_);

  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
}

void OpenGLLookAtCamera::setLookAtCamera(double positionX, double positionY, double positionZ,
                                         double lookAtX,   double lookAtY,   double lookAtZ,
                                         double upX,       double     upY,   double upZ)
{
  gluLookAt(positionX, positionY, positionZ,
            lookAtX,   lookAtY,   lookAtZ,
            upX,       upY,       upZ);
  // original test in framework
  //gluLookAt(0.0,  0.0, 15.0,
  //          0.0,  0.0,  0.0,
  //          0.0,  1.0,  0.0);
}