#include "OpenGLLight.h"

using namespace OpenGLRenderingEngine;

OpenGLLight::OpenGLLight() noexcept
{
 ambientColor_[0] = 0.2f;
 ambientColor_[1] = 0.2f;
 ambientColor_[2] = 0.2f;
 ambientColor_[3] = 1.0f;

 diffuseColor_[0] = 1.0f;
 diffuseColor_[1] = 1.0f;
 diffuseColor_[2] = 1.0f;
 diffuseColor_[3] = 1.0f;

 specularColor_[0] = 0.0f;
 specularColor_[1] = 0.0f;
 specularColor_[2] = 0.0f;
 specularColor_[3] = 1.0f;

  direction_[0] =  0.0f;
  direction_[1] =  0.0f;
  direction_[2] = -1.0f;
  direction_[3] =  0.0f; // directional light if w = 0.0f, else it's positional

  position_[0] = 0.0f;
  position_[1] = 0.0f;
  position_[2] = 0.0f;
  position_[3] = 1.0f;   // positional light if w = 1.0f, else it's directional
}

void OpenGLLight::setAmbientColor(float r, float g, float b, float a)
{
  ambientColor_[0] = r;
  ambientColor_[1] = g;
  ambientColor_[2] = b;
  ambientColor_[3] = a;
}

void OpenGLLight::setAmbientColor(const float ambientColor[4])
{
  setAmbientColor(ambientColor[0], ambientColor[1], ambientColor[2], ambientColor[3]);
}

void OpenGLLight::setDiffuseColor(float r, float g, float b, float a)
{
  diffuseColor_[0] = r;
  diffuseColor_[1] = g;
  diffuseColor_[2] = b;
  diffuseColor_[3] = a;
}

void OpenGLLight::setDiffuseColor(const float diffuseColor[4])
{
  setDiffuseColor(diffuseColor[0], diffuseColor[1], diffuseColor[2], diffuseColor[3]);
}

void OpenGLLight::setSpecularColor(float r, float g, float b, float a)
{
  specularColor_[0] = r;
  specularColor_[1] = g;
  specularColor_[2] = b;
  specularColor_[3] = a;
}

void OpenGLLight::setSpecularColor(const float specularColor[4])
{
  setSpecularColor(specularColor[0], specularColor[1], specularColor[2], specularColor[3]);
}

void OpenGLLight::setDirection(float x, float y, float z)
{
  direction_[0] = -x;
  direction_[1] = -y;
  direction_[2] = -z;
}

void OpenGLLight::setDirection(const float direction[3])
{
  setDirection(direction[0], direction[1], direction[2]);
}

void OpenGLLight::setPosition(float x, float y, float z)
{
  position_[0] = x;
  position_[1] = y;
  position_[2] = z;
}

void OpenGLLight::setPosition(const float position[3])
{
  setPosition(position[0], position[1], position[2]);
}

void OpenGLLight::enable(int lightId, bool usePositionalLight)
{
  glEnable(lightId);
  glLightfv(lightId, GL_AMBIENT,  ambientColor_);
  glLightfv(lightId, GL_DIFFUSE,  diffuseColor_);
  glLightfv(lightId, GL_SPECULAR, specularColor_);
  if (usePositionalLight)
  {
    glLightfv(lightId, GL_POSITION, position_);
  }
  else
  {
    glLightfv(lightId, GL_POSITION, direction_);
  }
  // glLightfv(GL_LIGHT0, GL_SPOT_DIRECTION, vector3f); // not using a spot light here
  // glLightf(GL_LIGHT0, GL_SPOT_CUTOFF, 180.0f); // angle is 0 to 180
  // glLightf(GL_LIGHT0, GL_SPOT_EXPONENT, 2.0f); // exponent is 0 to 128
  glLightf(lightId, GL_CONSTANT_ATTENUATION,  constantAttenuation_);
  glLightf(lightId, GL_LINEAR_ATTENUATION,    linearAttenuation_);
  glLightf(lightId, GL_QUADRATIC_ATTENUATION, quadraticAttenuation_);

  lastLightId_ = lightId;
}

void OpenGLLight::update(int lightId, bool usePositionalLight, float updateX, float updateY, float updateZ)
{
  if (usePositionalLight)
  {
    position_[0] += updateX;
    position_[1] += updateY;
    position_[2] += updateZ;

    glLightfv(lightId, GL_POSITION, position_);
  }
  else
  {
    direction_[0] -= updateX;
    direction_[1] -= updateY;
    direction_[2] -= updateZ;

    glLightfv(lightId, GL_POSITION, direction_);
  }

  lastLightId_ = lightId;
}

void OpenGLLight::disable() const
{
  glDisable(lastLightId_);
}