#include "OpenGLEulerCamera.h"
#include "glew.h"

using namespace OpenGLRenderingEngine;

OpenGLEulerCamera::OpenGLEulerCamera(float fieldOfView) noexcept
  : OpenGLCameraAbstractBase(fieldOfView)
{
}

void OpenGLEulerCamera::setMatrices() const
{
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluPerspective(fieldOfView_, ratio_, viewNear_, viewFar_);

  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
}

void OpenGLEulerCamera::setEulerCamera(double cameraDistanceX, double cameraDistanceY, double cameraDistanceZ,
                                       double cameraAngleX, double cameraAngleY,
                                       double sceneScaleFactor, double sceneCenterX, double sceneCenterY, double sceneCenterZ) const
{
  if (sceneScaleFactor != 0.0)
  {
    glScaled(sceneScaleFactor, sceneScaleFactor, sceneScaleFactor);
    glTranslated(cameraDistanceX / sceneScaleFactor, cameraDistanceY / sceneScaleFactor, -cameraDistanceZ / sceneScaleFactor);
  }
  else
  {
    glTranslated(cameraDistanceX, cameraDistanceY, -cameraDistanceZ);
  }
  glRotated(-cameraAngleX, 1.0, 0.0, 0.0);
  glRotated( cameraAngleY, 0.0, 1.0, 0.0);
  if ((sceneCenterX != 0.0) && (sceneCenterY != 0.0) && (sceneCenterZ != 0.0))
  {
    glTranslated(-sceneCenterX, -sceneCenterY, -sceneCenterZ);
  }
}