/*

Copyright (c) 2009-2018, Thanos Theo. All rights reserved.
Released Under a Simplified BSD (FreeBSD) License
for academic, personal & non-commercial use.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those
of the author and should not be interpreted as representing official policies,
either expressed or implied, of the FreeBSD Project.

A Commercial License is also available for commercial use with
special restrictions and obligations at a one-off fee. See links at:
1. http://www.dotredconsultancy.com/openglrenderingenginetoolrelease.php
2. http://www.dotredconsultancy.com/openglrenderingenginetoolsourcecodelicence.php
Please contact Thanos Theo (thanos.theo@dotredconsultancy.com) for more information.

*/

#pragma once

#ifndef __OpenGLUniqueColorsGenerator_h
#define __OpenGLUniqueColorsGenerator_h

#include "ModuleDLL.h"
#include "Randomizers.h"
#include "VectorTypes.h"
#include <vector>

/** @brief Namespace OpenGLRenderingEngine for the OpenGL rendering.
* @author Thanos Theo, 2018
* @version 14.0.0.0
*/
namespace OpenGLRenderingEngine
{
  /** @brief This class encapsulates usage of creating unique colors based on a prime number generator.
  * @author Thanos Theo, 2009-2018
  * @version 14.0.0.0
  */
  class OPENGL_RENDERING_ENGINE_MODULE_API OpenGLUniqueColorsGenerator
  {
  public:
    /**
    *  Creates unique colors based on a prime number generator, same color hues reproducible for every run.
    *  Verified for 6023986 uniquely generated colors.
    */
    std::vector<Utils::VectorTypes::float4> createUniqueColorsBasedOnPrimeNumbers(std::size_t numberOfColors);

    OpenGLUniqueColorsGenerator()  = default;
    ~OpenGLUniqueColorsGenerator() = default; // no virtual destructor for data-oriented design (no up-casting should ever be used)
    OpenGLUniqueColorsGenerator(const OpenGLUniqueColorsGenerator&) = delete; // copy-constructor deleted
    OpenGLUniqueColorsGenerator(OpenGLUniqueColorsGenerator&&)      = delete; // move-constructor deleted
    OpenGLUniqueColorsGenerator& operator=(const OpenGLUniqueColorsGenerator&) = delete; //      assignment operator deleted
    OpenGLUniqueColorsGenerator& operator=(OpenGLUniqueColorsGenerator&&)      = delete; // move-assignment operator deleted

  private:
    /// prime numbers color generator values
    std::size_t primeNumberIndex1_ =  3; // start with prime number   7
    std::size_t primeNumberIndex2_ = 18; // start with prime number  67
    std::size_t primeNumberIndex3_ = 27; // start with prime number 107

    /// the randomizer used for random colors
    Utils::Randomizers::RandomRNGWELL512 random_;
  };
} // namespace OpenGLRenderingEngine

#endif // __OpenGLUniqueColorsGenerator_h