/*

Copyright (c) 2009-2018, Thanos Theo. All rights reserved.
Released Under a Simplified BSD (FreeBSD) License
for academic, personal & non-commercial use.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those
of the author and should not be interpreted as representing official policies,
either expressed or implied, of the FreeBSD Project.

A Commercial License is also available for commercial use with
special restrictions and obligations at a one-off fee. See links at:
1. http://www.dotredconsultancy.com/openglrenderingenginetoolrelease.php
2. http://www.dotredconsultancy.com/openglrenderingenginetoolsourcecodelicence.php
Please contact Thanos Theo (thanos.theo@dotredconsultancy.com) for more information.

*/

#pragma once

#ifndef __OpenGLShaderSurfaceLightingModels_h
#define __OpenGLShaderSurfaceLightingModels_h

#include "ModuleDLL.h"
#include "OpenGLShaderProgram.h"

/** @brief Namespace OpenGLRenderingEngine for the OpenGL rendering.
* @author Thanos Theo, 2018
* @version 14.0.0.0
*/
namespace OpenGLRenderingEngine
{
  /** @brief This class loads & encapsulates usage of the 5 GLSL shader lighting models: Phong, Blinn-Phong, Gaussian, Toon & Gooch.
  * @author Thanos Theo, 2009-2018
  * @version 14.0.0.0
  */
  class OPENGL_RENDERING_ENGINE_MODULE_API OpenGLShaderSurfaceLightingModels : public OpenGLShaderProgram
  {
  public:

    void initializeShaderProgram() override;
    void useProgramAndUniforms(GLint numberOfLights, GLint lightingModel, GLint useOrenNayarDiffuseModel, GLint useFresnelFactorSchlickApproximationSpecularModel, GLint useColorMaterial, GLfloat sceneScaleFactor, GLint shrinkTriangles, GLint normals,
                               GLint texturing, GLuint activeTextureUnitFor2DTexture, GLint sphericalMapping, GLint environmentMapping,
                               GLint enforceColor, GLint blackOrWhite, GLint fog, GLint gammaCorrection, GLfloat opacity, GLfloat timer,
                               GLint useGBuffer,
                               GLint screenWidth = 512, GLint screenHeight = 512, GLint aBuffer3DSize = 32, GLint useOwnPackingMethodsForScreenshots = 0);

    OpenGLShaderSurfaceLightingModels(OpenGLDriverInfo* openGLDriverInfo, bool useGeometryShader, bool applyNormalsGeometry,
                                      bool useOITShaders = false, GLuint aBuffer3DMode = 1, GLuint aBuffer3DCounterUnit = 1, GLuint aBuffer3DDataUnit = 2,
                                      GLuint aBuffer3DLinkedListAtomicCounterUnit = 3, GLuint aBuffer3DLinkedListOffsetUnit = 4, GLuint aBuffer3DLinkedListUnit = 5,
                                      GLuint oitUseDeferredShading = 0) noexcept;
    OpenGLShaderSurfaceLightingModels()  = delete;
    ~OpenGLShaderSurfaceLightingModels() = default;
    OpenGLShaderSurfaceLightingModels(const OpenGLShaderSurfaceLightingModels&) = delete;
    OpenGLShaderSurfaceLightingModels(OpenGLShaderSurfaceLightingModels&&)      = delete;
    OpenGLShaderSurfaceLightingModels& operator=(const OpenGLShaderSurfaceLightingModels&) = delete;
    OpenGLShaderSurfaceLightingModels& operator=(OpenGLShaderSurfaceLightingModels&&)      = delete;

  private:

    bool useGeometryShader_                      = false;
    bool applyNormalsGeometry_                   = false;
    bool useOITShaders_                          = false;
    GLuint aBuffer3DMode_                        = 0;
    GLuint aBuffer3DCounterUnit_                 = 0;
    GLuint aBuffer3DDataUnit_                    = 0;
    GLuint aBuffer3DLinkedListAtomicCounterUnit_ = 0;
    GLuint aBuffer3DLinkedListOffsetUnit_        = 0;
    GLuint aBuffer3DLinkedListUnit_              = 0;
    GLuint oitUseDeferredShading_                = 0;
  };
} // namespace OpenGLRenderingEngine

#endif // __OpenGLShaderSurfaceLightingModels_h