/*

Copyright (c) 2009-2018, Thanos Theo. All rights reserved.
Released Under a Simplified BSD (FreeBSD) License
for academic, personal & non-commercial use.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those
of the author and should not be interpreted as representing official policies,
either expressed or implied, of the FreeBSD Project.

A Commercial License is also available for commercial use with
special restrictions and obligations at a one-off fee. See links at:
1. http://www.dotredconsultancy.com/openglrenderingenginetoolrelease.php
2. http://www.dotredconsultancy.com/openglrenderingenginetoolsourcecodelicence.php
Please contact Thanos Theo (thanos.theo@dotredconsultancy.com) for more information.

*/

#pragma once

#ifndef __OpenGLShaderGLSLPreProcessorCommands_h
#define __OpenGLShaderGLSLPreProcessorCommands_h

#include "ModuleDLL.h"
#include <sstream>
#include <string>

/** @brief Namespace OpenGLRenderingEngine for the OpenGL rendering.
* @author Thanos Theo, 2018
* @version 14.0.0.0
*/
namespace OpenGLRenderingEngine
{
  // forward declaration
  class OpenGLDriverInfo;

  /** @brief This class is responsible for the GLSL shader preprocessor process.
  * @author Thanos Theo, 2009-2018
  * @version 14.0.0.0
  */
  class OPENGL_RENDERING_ENGINE_MODULE_API OpenGLShaderGLSLPreProcessorCommands final
  {
  public:

    /// add highest GL version definition
    void addHighestGLVersionDefinition();
    /// add GL 2.1 version definition
    void addGL21VersionDefinition();
    /// add GL 3.3 version definition
    void addGL33VersionDefinition();
    /// add GL 4.2 version definition
    void addGL42VersionDefinition();
    /// add GL 4.3 version definition
    void addGL43VersionDefinition();
    /// add GL 4.4 version definition
    void addGL44VersionDefinition();
    /// add GL 4.5 version definition
    void addGL45VersionDefinition();
    /// add definition
    void addDefinition(const std::string& definition);
    /// add definition and condition
    void addDefinitionAndCondition(const std::string& definition, int condition);
    /// add preprocessor line
    void addPreprocessorLine(const std::string& GLSLPreProcessorLine);
    /// add definition for starting line
    void addDefinitionForStartingLine();
    /// get current GLSL preprocessor commands
    std::string getCurrentGLSLPreProcessorCommands() const { return allGLSLPreProcessorCommands_.str(); }
    /// get GLSL preprocessor commands
    std::string getFinalizedGLSLPreProcessorCommands();
    /// clear GLSL preprocessor commands
    void clearGLSLPreProcessorCommands();

    explicit OpenGLShaderGLSLPreProcessorCommands(OpenGLDriverInfo* openGLDriverInfo) noexcept;
    ~OpenGLShaderGLSLPreProcessorCommands() noexcept;
    OpenGLShaderGLSLPreProcessorCommands() = delete;
    OpenGLShaderGLSLPreProcessorCommands(const OpenGLShaderGLSLPreProcessorCommands&) = delete; // copy-constructor deleted
    OpenGLShaderGLSLPreProcessorCommands(OpenGLShaderGLSLPreProcessorCommands&&)      = delete; // move-constructor deleted
    OpenGLShaderGLSLPreProcessorCommands& operator=(const OpenGLShaderGLSLPreProcessorCommands&) = delete; //      assignment operator deleted
    OpenGLShaderGLSLPreProcessorCommands& operator=(OpenGLShaderGLSLPreProcessorCommands&&)      = delete; // move-assignment operator deleted

  private:

    OpenGLDriverInfo* openGLDriverInfo_ = nullptr;
    std::ostringstream allGLSLPreProcessorCommands_;
  };
} // namespace OpenGLRenderingEngine

#endif // __OpenGLShaderGLSLPreProcessorCommands_h