/*

Copyright (c) 2009-2018, Thanos Theo. All rights reserved.
Released Under a Simplified BSD (FreeBSD) License
for academic, personal & non-commercial use.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those
of the author and should not be interpreted as representing official policies,
either expressed or implied, of the FreeBSD Project.

A Commercial License is also available for commercial use with
special restrictions and obligations at a one-off fee. See links at:
1. http://www.dotredconsultancy.com/openglrenderingenginetoolrelease.php
2. http://www.dotredconsultancy.com/openglrenderingenginetoolsourcecodelicence.php
Please contact Thanos Theo (thanos.theo@dotredconsultancy.com) for more information.

*/

#pragma once

#ifndef __OpenGLShaderCompileAndLink_h
#define __OpenGLShaderCompileAndLink_h

#include "ModuleDLL.h"
#include "glew.h"
#include <string>
#include <unordered_map>

/** @brief Namespace OpenGLRenderingEngine for the OpenGL rendering.
* @author Thanos Theo, 2018
* @version 14.0.0.0
*/
namespace OpenGLRenderingEngine
{
  // forward declarations
  class OpenGLDriverInfo;
  class OpenGLShaderGLSLPreProcessorCommands;
  class OpenGLShaderObjects;

  /** @brief This class encapsulates loading, compilation & linking of a GLSL program.
  * @author Thanos Theo, 2009-2018
  * @version 14.0.0.0
  */
  class OPENGL_RENDERING_ENGINE_MODULE_API OpenGLShaderCompileAndLink final
  {
  public:

    /// add shader library to program
    void addShaderLibraryToProgram(const std::string& shaderLibraryPathName, const std::string& shaderLibraryName, int shaderType);
    /// link shader program
    void linkShaderProgram(GLint inputTopology = GL_TRIANGLES, GLint outputTopology = GL_TRIANGLE_STRIP, GLint maxVerticesOut = 256);

    OpenGLShaderCompileAndLink(OpenGLDriverInfo* openGLDriverInfo, OpenGLShaderGLSLPreProcessorCommands* openGLShaderGLSLPreProcessorCommands, GLuint shaderProgram) noexcept;
    ~OpenGLShaderCompileAndLink() noexcept;

    OpenGLShaderCompileAndLink() = delete;
    OpenGLShaderCompileAndLink(const OpenGLShaderCompileAndLink&) = delete;
    OpenGLShaderCompileAndLink(OpenGLShaderCompileAndLink&&)      = delete;
    OpenGLShaderCompileAndLink& operator=(const OpenGLShaderCompileAndLink&) = delete;
    OpenGLShaderCompileAndLink& operator=(OpenGLShaderCompileAndLink&&)      = delete;

  private:

    OpenGLDriverInfo* openGLDriverInfo_                                         = nullptr;
    OpenGLShaderGLSLPreProcessorCommands* openGLShaderGLSLPreProcessorCommands_ = nullptr;
    GLuint shaderProgram_                                                       = 0;
    std::string mergedShaderLibraryName_                                        = "";
    std::unordered_map<std::string, OpenGLShaderObjects*> allOpenGLShaderObjectsMap_;

    /// compile shader
    void compileShader(const std::string& shaderLibraryPathName, const std::string& shaderLibraryName, const std::string& shaderFileNameExtension, const std::string& shaderFileName, int shaderTypeEnum, const OpenGLShaderObjects* openGLShaderObjects, const std::string& shaderTypeString) const;
    /// check if a geometry shader object was created
    bool checkUsageOfGeometryShaderObject();
    /// check GL info log function
    void checkInfoLog(const std::string& shaderName, GLuint obj) const;
    /// release all shader objects
    void releaseAllShaderObjects();
  };
} // namespace OpenGLRenderingEngine

#endif // __OpenGLShaderCompileAndLink_h