/*

Copyright (c) 2009-2018, Thanos Theo. All rights reserved.
Released Under a Simplified BSD (FreeBSD) License
for academic, personal & non-commercial use.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those
of the author and should not be interpreted as representing official policies,
either expressed or implied, of the FreeBSD Project.

A Commercial License is also available for commercial use with
special restrictions and obligations at a one-off fee. See links at:
1. http://www.dotredconsultancy.com/openglrenderingenginetoolrelease.php
2. http://www.dotredconsultancy.com/openglrenderingenginetoolsourcecodelicence.php
Please contact Thanos Theo (thanos.theo@dotredconsultancy.com) for more information.

*/

#pragma once

#ifndef __OpenGLQueryTimer_h
#define __OpenGLQueryTimer_h

#include "ModuleDLL.h"
#include "AccurateTimers.h"
#include "glew.h"

/** @brief Namespace OpenGLRenderingEngine for the OpenGL rendering.
* @author Thanos Theo, 2018
* @version 14.0.0.0
*/
namespace OpenGLRenderingEngine
{
  /** @brief This class contains an AccurateTimers encapsulation of OpenGL query timers.
  *
  *  OpenGLQueryTimer.h:
  *  ==================
  *  This class contains an AccurateTimers encapsulation of OpenGL query timers.
  *  Note: no virtual destructor is needed for data-oriented design
  *  ie no up-casting should ever be used.
  *
  * @author Thanos Theo, 2018
  */
  class OPENGL_RENDERING_ENGINE_MODULE_API OpenGLQueryTimer final : Utils::AccurateTimers::AccurateTimerInterface<OpenGLQueryTimer>, private Utils::AccurateTimers::AccurateTimerLog // private inheritance used for composition and prohibiting up-casting
  {
  public:

    void startTimer();
    void stopTimer();
    double getElapsedTimeInNanoSecs();
    double getElapsedTimeInMicroSecs();
    double getElapsedTimeInMilliSecs();
    double getElapsedTimeInSecs();
    double getMeanTimeInNanoSecs();
    double getMeanTimeInMicroSecs();
    double getMeanTimeInMilliSecs();
    double getMeanTimeInSecs();
    double getDecimalElapsedTimeInMicroSecs();
    double getDecimalElapsedTimeInMilliSecs();
    double getDecimalElapsedTimeInSecs();
    double getDecimalMeanTimeInMicroSecs();
    double getDecimalMeanTimeInMilliSecs();
    double getDecimalMeanTimeInSecs();

    OpenGLQueryTimer() noexcept;
    ~OpenGLQueryTimer() noexcept; // no virtual destructor for data-oriented design (no up-casting should ever be used)
    OpenGLQueryTimer(const OpenGLQueryTimer&) = delete; // copy-constructor deleted
    OpenGLQueryTimer(OpenGLQueryTimer&&)      = delete; // move-constructor deleted
    OpenGLQueryTimer& operator=(const OpenGLQueryTimer&) = delete; //      assignment operator deleted
    OpenGLQueryTimer& operator=(OpenGLQueryTimer&&)      = delete; // move-assignment operator deleted

  private:

    bool stopped_           = false;
    GLuint query_           = 0;
    GLuint64 renderingTime_ = 0;

    double getElapsedTime();
  };
} // namespace OpenGLRenderingEngine

#endif // __OpenGLQueryTimer_h