/*

Copyright (c) 2009-2018, Thanos Theo. All rights reserved.
Released Under a Simplified BSD (FreeBSD) License
for academic, personal & non-commercial use.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those
of the author and should not be interpreted as representing official policies,
either expressed or implied, of the FreeBSD Project.

A Commercial License is also available for commercial use with
special restrictions and obligations at a one-off fee. See links at:
1. http://www.dotredconsultancy.com/openglrenderingenginetoolrelease.php
2. http://www.dotredconsultancy.com/openglrenderingenginetoolsourcecodelicence.php
Please contact Thanos Theo (thanos.theo@dotredconsultancy.com) for more information.

*/

#pragma once

#ifndef __OpenGLILTexture_h
#define __OpenGLILTexture_h

#include "ModuleDLL.h"
#include "glew.h"
#include "ilu.h"
#include <string>

struct ILimage; // used for forward-declarations

/** @brief Namespace OpenGLRenderingEngine for the OpenGL rendering.
* @author Thanos Theo, 2018
* @version 14.0.0.0
*/
namespace OpenGLRenderingEngine
{
  /** @brief This class encapsulates usage of an OpenGL texture using the DevIL library for image handling.
  * @author Thanos Theo, 2009-2018
  * @version 14.0.0.0
  */
  class OPENGL_RENDERING_ENGINE_MODULE_API OpenGLILTexture final
  {
  public:

    static void saveILImage(const std::string& imageDirectory, const std::string& imageFileNamePrefix, const std::string& imageFileNameExtension, ILubyte imageFormat, ILuint imageWidth, ILuint imageHeight, ILubyte* imagePixels);

    GLuint getILTextureID() const { return ILtextureID_; }
    void createILTexture(const std::string& textureDirectory, const std::string& textureFileName, bool enforceImageFlip = true, GLenum textureUnit = 0);
    void deleteILTexture();
    void enable() const;
    void disable() const;
    void bindTexture(GLenum textureUnit = 0) const;
    void unbind(GLenum textureUnit) const;

    OpenGLILTexture(bool generateMipmap = false, bool supportsMaxTextureMaxAnisotropy = false, GLint maxTextureMaxAnisotropy = 0) noexcept;
    ~OpenGLILTexture() noexcept;
    OpenGLILTexture(const OpenGLILTexture&) = delete;
    OpenGLILTexture(OpenGLILTexture&&)      = delete;
    OpenGLILTexture& operator=(const OpenGLILTexture&) = delete;
    OpenGLILTexture& operator=(OpenGLILTexture&&)      = delete;

  private:

    GLuint ILtextureID_                   = 0;
    bool generateMipmap_                  = false;
    bool supportsMaxTextureMaxAnisotropy_ = false;
    GLint maxTextureMaxAnisotropy_        = 0;
  };
} // namespace OpenGLRenderingEngine

#endif // __OpenGLILTexture_h