/*

Copyright (c) 2009-2018, Thanos Theo. All rights reserved.
Released Under a Simplified BSD (FreeBSD) License
for academic, personal & non-commercial use.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those
of the author and should not be interpreted as representing official policies,
either expressed or implied, of the FreeBSD Project.

A Commercial License is also available for commercial use with
special restrictions and obligations at a one-off fee. See links at:
1. http://www.dotredconsultancy.com/openglrenderingenginetoolrelease.php
2. http://www.dotredconsultancy.com/openglrenderingenginetoolsourcecodelicence.php
Please contact Thanos Theo (thanos.theo@dotredconsultancy.com) for more information.

*/

#pragma once

#ifndef __OpenGLAbstractBase_h
#define __OpenGLAbstractBase_h

#include <limits>

/** @brief Namespace OpenGLRenderingEngine for the OpenGL rendering.
* @author Thanos Theo, 2018
* @version 14.0.0.0
*/
namespace OpenGLRenderingEngine
{
  /** @brief This abstract class encapsulates usage of an OpenGL camera. To be inherited from usage-specific sub-classes.
  * @author Thanos Theo, 2009-2018
  * @version 14.0.0.0
  */
  class OpenGLCameraAbstractBase
  {
  public:

    float getFieldOfView() const { return fieldOfView_; }
    float getRatio()       const { return ratio_;       }
    float getViewNear()    const { return viewNear_;    }
    float getViewFar()     const { return viewFar_;     }
    void setFieldOfView(float fieldOfView) { fieldOfView_ = fieldOfView; }
    void setRatio(float ratio)             { ratio_       = ratio;       }
    void setViewNear(float viewNear)       { viewNear_    = viewNear;    }
    void setViewFar(float viewFar)         { viewFar_     = viewFar;     }

    virtual void setMatrices() const = 0;

    OpenGLCameraAbstractBase(const OpenGLCameraAbstractBase&) = delete;
    OpenGLCameraAbstractBase(OpenGLCameraAbstractBase&&)      = delete;
    OpenGLCameraAbstractBase& operator=(const OpenGLCameraAbstractBase&) = delete;
    OpenGLCameraAbstractBase& operator=(OpenGLCameraAbstractBase&&)      = delete;

  protected:

    float fieldOfView_ = 0.0f;
    float ratio_       = 0.0f;
    float viewNear_    = 0.01f;
    float viewFar_     = std::numeric_limits<float>::max();

    explicit OpenGLCameraAbstractBase(float fieldOfView) noexcept : fieldOfView_(fieldOfView) {} // an abstract class has its constructor as protected
    virtual ~OpenGLCameraAbstractBase() = default; // virtual destructor so as to be called from implementing sub-classes (only them can be deleted)
  };
} // namespace OpenGLRenderingEngine

#endif // __OpenGLAbstractBase_h