/*

Copyright (c) 2009-2018, Thanos Theo. All rights reserved.
Released Under a Simplified BSD (FreeBSD) License
for academic, personal & non-commercial use.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those
of the author and should not be interpreted as representing official policies,
either expressed or implied, of the FreeBSD Project.

A Commercial License is also available for commercial use with
special restrictions and obligations at a one-off fee. See links at:
1. http://www.dotredconsultancy.com/openglrenderingenginetoolrelease.php
2. http://www.dotredconsultancy.com/openglrenderingenginetoolsourcecodelicence.php
Please contact Thanos Theo (thanos.theo@dotredconsultancy.com) for more information.

*/

#pragma once

#ifndef __OpenGLAssetManager_h
#define __OpenGLAssetManager_h

#include "ModuleDLL.h"
#include <string>

/** @brief Namespace OpenGLRenderingEngine for the OpenGL rendering.
* @author Thanos Theo, 2018
* @version 14.0.0.0
*/
namespace OpenGLRenderingEngine
{
  /** @brief This class encapsulates usage of an OpenGL Asset Manager.
  * @author Thanos Theo, 2009-2018
  * @version 14.0.0.0
  */
  struct OPENGL_RENDERING_ENGINE_MODULE_API OpenGLAssetManager final
  {
    enum ShaderTypes : std::size_t
    {
      VS  = (1 << 0),
      TCS = (1 << 1),
      TES = (1 << 2),
      GS  = (1 << 3),
      FS  = (1 << 4),
      CS  = (1 << 5)
    };

    enum CharacterEncodingMethods : std::size_t
    {
      NONE                                  = 0,
      BASE64                                = 1,
      FLIP_BITS                             = 2,
      FLIP_XOR_SWAP_BITS                    = 3,
      BASE64_FLIP_XOR_SWAP_BITS             = 4,
      BASE64_COMPRESSION                    = 5,
      BASE64_FLIP_XOR_SWAP_BITS_COMPRESSION = 6
    };

    static constexpr size_t                   NUMBER_OF_TOTAL_SHADER_TYPES = 6;
    static constexpr CharacterEncodingMethods CHARACTER_ENCODING_METHOD    = BASE64_FLIP_XOR_SWAP_BITS_COMPRESSION;

    static std::string getGLSLInternalDirectory()                          { return "GLSL/"; }
    static std::string getVertexShadersFileName()                          { return "vertexShader";                 }
    static std::string getTessellationControlShadersFileName()             { return "tessellationControlShader";    }
    static std::string getTessellationEvaluationShadersFileName()          { return "tessellationEvaluationShader"; }
    static std::string getGeometryShadersFileName()                        { return "geometryShader";               }
    static std::string getFragmentShadersFileName()                        { return "fragmentShader";               }
    static std::string getComputeShadersFileName()                         { return "computeShader";                }
    static std::string getVertexShadersFileNameExtension()                 { return ".vert"; }
    static std::string getTessellationControlShadersFileNameExtension()    { return ".tcs";  }
    static std::string getTessellationEvaluationShadersFileNameExtension() { return ".tes";  }
    static std::string getGeometryShadersFileNameExtension()               { return ".geom"; }
    static std::string getFragmentShadersFileNameExtension()               { return ".frag"; }
    static std::string getComputeShadersFileNameExtension()                { return ".cs";   }

    static std::string getAssetsDefaultDirectory()   { return "Assets/"; }
    static std::string getGLSLDefaultDirectory()     { return getAssetsDefaultDirectory() + getGLSLInternalDirectory(); }
    static std::string getImagesDefaultDirectory()   { return getAssetsDefaultDirectory() + "Images/"; }
    static std::string getModelsDefaultDirectory()   { return getAssetsDefaultDirectory() + "Models/"; }
    static std::string getTexturesDefaultDirectory() { return getAssetsDefaultDirectory() + "Textures/"; }
    static std::string getDefaultScreenshotFormat()  { return "png"; }

    OpenGLAssetManager()  = delete;
    ~OpenGLAssetManager() = delete;
    OpenGLAssetManager(const OpenGLAssetManager&) = delete;
    OpenGLAssetManager(OpenGLAssetManager&&)      = delete;
    OpenGLAssetManager& operator=(const OpenGLAssetManager&) = delete;
    OpenGLAssetManager& operator=(OpenGLAssetManager&&)      = delete;
  };
} // namespace OpenGLRenderingEngine

#endif // __OpenGLAssetManager_h