#pragma once

#ifndef __OPENGL_RENDERING_ENGINE_MODULEDLL_H_INCL__
#define __OPENGL_RENDERING_ENGINE_MODULEDLL_H_INCL__

#ifdef __cplusplus
extern "C"
{
#endif

/**
*  ModuleDLL.h
*  Definitions for Module DLL
*/

#if defined _WIN32
  /** Definitions for exporting or importing the Module DLL
  * In MSVC projects, DLL projects should add BUILD_MODULE_DLL to Preprocessor definitions.
  * The default is MODULE_EXPORTS so that should be replaced.
  * For projects linking with this dll, they should add LINK_DLL to Preprocessor definitions.
  * This includes DLL projects which link with other DLL projects.
  */
  #if defined OpenGLRenderingEngine_EXPORTS
    #define OPENGL_RENDERING_ENGINE_MODULE_API __declspec(dllexport)
    #pragma warning (push)
    #pragma warning (disable : 4251) // for std member dll export
    #pragma warning (push)
    #pragma warning (disable : 4275) // for dll-interface struct/class export
  #elif defined LINK_DLL
    #define OPENGL_RENDERING_ENGINE_MODULE_API __declspec(dllimport)
  #else
    #define OPENGL_RENDERING_ENGINE_MODULE_API
  #endif
#else /* non-Windows OSs don't need all this */
  #define OPENGL_RENDERING_ENGINE_MODULE_API
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif  /* __OPENGL_RENDERING_ENGINE_MODULEDLL_H_INCL__ */