/*

  Copyright (c) 2009-2018, Thanos Theo. All rights reserved.
  Released Under a Simplified BSD (FreeBSD) License
  for academic, personal & non-commercial use.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

  The views and conclusions contained in the software and documentation are those
  of the author and should not be interpreted as representing official policies,
  either expressed or implied, of the FreeBSD Project.

  A Commercial License is also available for commercial use with
  special restrictions and obligations at a one-off fee. See links at:
  1. http://www.dotredconsultancy.com/openglrenderingenginetoolrelease.php
  2. http://www.dotredconsultancy.com/openglrenderingenginetoolsourcecodelicence.php
  Please contact Thanos Theo (thanos.theo@dotredconsultancy.com) for more information.

*/

/**
*
*  Apply Surface Lighting Models GLSL code for Phong, Blinn-Phong, Gaussian, Toon, Gooch.
*  Using core functions from CommonFunctions & SurfaceLightingModels GLSL libraries.
*  References:
*  1. en.wikipedia.org/wiki/Phong_reflection_model                   -> Phong Specular Lighting Model
*  2. en.wikipedia.org/wiki/Blinn%E2%80%93Phong_shading_model        -> Blinn-Phong Specular Lighting Model
*  3. en.wikipedia.org/wiki/Specular_highlight#Gaussian_distribution -> Gaussiang Specular Lighting Model
*  4. en.wikipedia.org/wiki/Cel_shading                              -> Toon Specular Lighting Model
*  5. www.cs.northwestern.edu/~ago820/SIG98/abstract.html            -> Gooch Specular Lighting Model
*  6. en.wikipedia.org/wiki/Oren%E2%80%93Nayar_reflectance_model     -> Oren-Nayar Diffuse Lighting Model
*  7. en.wikipedia.org/wiki/Reflection_mapping#Sphere_mapping        -> Reflection (Sphere) Mapping
*  8. en.wikipedia.org/wiki/Reflection_mapping                       -> Reflection Mapping
*
*  Relevant variables controlling the above: sphericalMapping
*  Relevant functions: applySphericalCoordinates()
*
* @author Thanos Theo, 2009-2018
* @version 14.0.0.0
*/

VS_VARYING vec3 VS_NORMAL;
VS_VARYING vec3 VS_EYE_VECTOR;

uniform bool texturing = false;
uniform bool sphericalMapping = false;
uniform bool environmentMapping = false;

vec2 applySphericalCoordinates(in vec3 position, in vec3 normal);

void main()
{
  vec4 position = gl_ModelViewMatrix * gl_Vertex;
  VS_EYE_VECTOR = position.xyz;
  VS_NORMAL     = gl_NormalMatrix * gl_Normal;
#if GPU_GEOMETRY_SHADER4_COMPATIBILITY_CONDITION
  gl_Position   = gl_Vertex;
  gl_ClipVertex = gl_Vertex;
#else
  gl_Position   = gl_ModelViewProjectionMatrix * gl_Vertex;
  gl_ClipVertex = position;
#endif
  gl_FrontColor = gl_Color;
  gl_BackColor  = gl_Color;

  if (texturing)
  {
    gl_TexCoord[0] = (sphericalMapping && !environmentMapping) ? vec4(applySphericalCoordinates(VS_EYE_VECTOR, VS_NORMAL), (gl_TextureMatrix[0] * gl_MultiTexCoord0).pq) : gl_TextureMatrix[0] * gl_MultiTexCoord0;
  }
}