/*

  Copyright (c) 2009-2018, Thanos Theo. All rights reserved.
  Released Under a Simplified BSD (FreeBSD) License
  for academic, personal & non-commercial use.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

  The views and conclusions contained in the software and documentation are those
  of the author and should not be interpreted as representing official policies,
  either expressed or implied, of the FreeBSD Project.

  A Commercial License is also available for commercial use with
  special restrictions and obligations at a one-off fee. See links at:
  1. http://www.dotredconsultancy.com/openglrenderingenginetoolrelease.php
  2. http://www.dotredconsultancy.com/openglrenderingenginetoolsourcecodelicence.php
  Please contact Thanos Theo (thanos.theo@dotredconsultancy.com) for more information.

*/

/**
*
*  Apply Surface Lighting Models GLSL code for Phong, Blinn-Phong, Gaussian, Toon, Gooch.
*
* @author Thanos Theo, 2009-2018
* @version 14.0.0.0
*/

#extension GL_EXT_geometry_shader4 : enable

uniform bool shrinkTriangles = false;
uniform bool texturing = false;
uniform bool normals = false;

void applyTriangleGeometry(in bool useShrinkFactor, in float shrinkFactor, in bool useNoiseOffset, in bool useTexturing);
#if APPLY_NORMALS_GEOMETRY_CONDITION
  void applyNormalsGeometry();
#endif

// warning, Intel GPU driver crashes with the GL GS CPU-side option calls, have to use the shader layout GL 3.3+ syntax
#if GPU_VENDOR_NOT_NVIDIA
  layout(triangles) in;
  layout(triangle_strip, max_vertices = GS_PRIMITIVE_MAX_VERTICES_OUT) out;
#endif

void main()
{
  applyTriangleGeometry(shrinkTriangles || normals, 0.90, shrinkTriangles, texturing);
  
  #if APPLY_NORMALS_GEOMETRY_CONDITION
  if (normals)
  {
    applyNormalsGeometry();
  }
  #endif
}