/*

  Copyright (c) 2009-2018, Thanos Theo. All rights reserved.
  Released Under a Simplified BSD (FreeBSD) License
  for academic, personal & non-commercial use.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

  The views and conclusions contained in the software and documentation are those
  of the author and should not be interpreted as representing official policies,
  either expressed or implied, of the FreeBSD Project.

  A Commercial License is also available for commercial use with
  special restrictions and obligations at a one-off fee. See links at:
  1. http://www.dotredconsultancy.com/openglrenderingenginetoolrelease.php
  2. http://www.dotredconsultancy.com/openglrenderingenginetoolsourcecodelicence.php
  Please contact Thanos Theo (thanos.theo@dotredconsultancy.com) for more information.

*/

/**
*
*  Apply Quad Sphere Model GLSL code.
*  Using core functions from CommonFunctions & SurfaceLightingModels GLSL libraries.
*
*  Relevant variables controlling the above: useActorColor, actorColor, lightingModel, perspectiveCorrection & windowRatio
*
* @author Thanos Theo, 2009-2018
* @version 14.0.0.0
*/

uniform float radiusFactor = 1.0;
uniform bool useActorColor = false;
uniform vec3 actorColor    = vec3(1.0);

VS_VARYING float VS_SPHERE_RADIUS;
VS_VARYING vec4 VS_SPHERE_COLOR;

#if GPU_GEOMETRY_SHADER4_COMPATIBILITY_CONDITION
#else
  uniform int lightingModel = 2; // Blinn-Phong by default
  uniform bool pointAntialias = false;
  uniform bool perspectiveCorrection = false;
  uniform float windowRatio = 1.0;
  VS_VARYING float VS_SPHERE_CIRCULAR_FACTOR;
  VS_VARYING vec2 VS_MAPPING;
  VS_VARYING vec3 VS_CAMERA_SPHERE_POSITION;
  float getSphericalDistanceFromCenter(in float radius, in vec3 center);
#endif

void main()
{
  VS_SPHERE_RADIUS = radiusFactor * gl_Vertex.w;
#if GPU_GEOMETRY_SHADER4_COMPATIBILITY_CONDITION
#else
  gl_TexCoord[0] = gl_TextureMatrix[0] * gl_MultiTexCoord0;
  if (pointAntialias)
  {
    VS_SPHERE_CIRCULAR_FACTOR = getSphericalDistanceFromCenter(VS_SPHERE_RADIUS, gl_Vertex.xyz);
  }
  VS_MAPPING = ((lightingModel != 0) && perspectiveCorrection && (windowRatio > 1.0)) ? windowRatio * gl_TexCoord[0].st : gl_TexCoord[0].st;
#endif
  VS_SPHERE_COLOR = (useActorColor) ? vec4(actorColor, 1.0) : gl_Color;

#if GPU_GEOMETRY_SHADER4_COMPATIBILITY_CONDITION
  gl_Position = vec4(gl_Vertex.xyz, 1.0);
  gl_ClipVertex = vec4(gl_Vertex.xyz, 1.0);
#else
  vec4 eyeVector = gl_ModelViewMatrix * vec4(gl_Vertex.xyz, 1.0);
  VS_CAMERA_SPHERE_POSITION = eyeVector.xyz;
  eyeVector.xy += VS_SPHERE_RADIUS * VS_MAPPING;

  gl_Position = gl_ProjectionMatrix * eyeVector;
  gl_ClipVertex = eyeVector;
#endif
}