/*

  Copyright (c) 2009-2018, Thanos Theo. All rights reserved.
  Released Under a Simplified BSD (FreeBSD) License
  for academic, personal & non-commercial use.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

  The views and conclusions contained in the software and documentation are those
  of the author and should not be interpreted as representing official policies,
  either expressed or implied, of the FreeBSD Project.

  A Commercial License is also available for commercial use with
  special restrictions and obligations at a one-off fee. See links at:
  1. http://www.dotredconsultancy.com/openglrenderingenginetoolrelease.php
  2. http://www.dotredconsultancy.com/openglrenderingenginetoolsourcecodelicence.php
  Please contact Thanos Theo (thanos.theo@dotredconsultancy.com) for more information.

*/

/**
*
*  Apply Clear A-Buffer-3D code.
*
* @author Thanos Theo, 2009-2018
* @version 14.0.0.0
*/

#extension GL_ARB_gpu_shader5 : enable
#if A_BUFFER_3D_USE_TEXTURES
  #extension GL_EXT_shader_image_load_store : enable
#else
  #extension GL_ARB_shader_storage_buffer_object : enable
#endif

// layout(pixel_center_integer) in vec4 gl_FragCoord; // whole number pixel offsets
layout(early_fragment_tests) in;
#if A_BUFFER_3D_USE_TEXTURES
  layout(r32ui, binding = ACTIVE_TEXTURE_UNIT_FOR_A_BUFFER_3D_COUNTER) coherent writeonly volatile uniform uimage2D     aBuffer3DCounterImage;
#else
  layout(std430, binding = ACTIVE_TEXTURE_UNIT_FOR_A_BUFFER_3D_COUNTER) coherent volatile buffer Counter { uint aBuffer3DCounterBuffer[]; };
#endif

uniform int screenWidth  = 512;
uniform int screenHeight = 512;

void main()
{
  ivec2 coords = ivec2(gl_FragCoord.xy);
  if ((coords.x >= 0) && (coords.y >= 0) && (coords.x < screenWidth) && (coords.y < screenHeight))
  {
    // reset counter (the A-Buffer-3D doesn't really need cleaning)
  #if A_BUFFER_3D_USE_TEXTURES
    imageStore(aBuffer3DCounterImage, coords, uvec4(0));
  #else
    aBuffer3DCounterBuffer[coords.x + screenWidth * coords.y] = 0;
  #endif
  }

  // discard fragment so nothing is written to the framebuffer
  discard;
}