/*

  Copyright (c) 2009-2018, Thanos Theo. All rights reserved.
  Released Under a Simplified BSD (FreeBSD) License
  for academic, personal & non-commercial use.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

  The views and conclusions contained in the software and documentation are those
  of the author and should not be interpreted as representing official policies,
  either expressed or implied, of the FreeBSD Project.

  A Commercial License is also available for commercial use with
  special restrictions and obligations at a one-off fee. See links at:
  1. http://www.dotredconsultancy.com/openglrenderingenginetoolrelease.php
  2. http://www.dotredconsultancy.com/openglrenderingenginetoolsourcecodelicence.php
  Please contact Thanos Theo (thanos.theo@dotredconsultancy.com) for more information.

*/

/**
*
*  Apply GBuffer Effects HSSAO GLSL code.
*
*  Note: a full deferred shading rendering framework framework should apply the HSSAO term only to the ambient term of the lighting equation like the code below:
*  ->  gl_FragColor = unpackedColor + unpackedAmbientTerm * HSSAOColorBlurred;
*  We keep it simple with our current rendering framework and apply the HSSAO term to the whole lighting equation, which is not fully correct for the lighting model.
*  Detailed explanation: Its called ambient occlusion (AO) for a reason. It should only be incorporated in the ambient term of our image. So we need to keep AO out of the directly illuminated parts.
*  Why? Consider a real-life example of light hitting a dark corner. If we point our desk light into the dark corner, then suddenly there is no ambient occlusion in the corner any more.
*
* @author Thanos Theo, 2009-2018
* @version 14.0.0.0
*/

uniform sampler2D gbufferSampler;
uniform sampler2D HSSAOBlurredXYSampler;

vec4 unpackUnsignedIntegerToFloat4(in uint value);

void main()
{
  vec4 packedData        = texture2D(gbufferSampler, gl_TexCoord[0].st);
  vec4 unpackedColor     = unpackUnsignedIntegerToFloat4(floatBitsToUint(packedData.x));
  vec4 HSSAOColorBlurred = texture2D(HSSAOBlurredXYSampler, gl_TexCoord[0].st);

  gl_FragColor = unpackedColor * HSSAOColorBlurred;
}