/*

  Copyright (c) 2009-2018, Thanos Theo. All rights reserved.
  Released Under a Simplified BSD (FreeBSD) License
  for academic, personal & non-commercial use.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

  The views and conclusions contained in the software and documentation are those
  of the author and should not be interpreted as representing official policies,
  either expressed or implied, of the FreeBSD Project.

  A Commercial License is also available for commercial use with
  special restrictions and obligations at a one-off fee. See links at:
  1. http://www.dotredconsultancy.com/openglrenderingenginetoolrelease.php
  2. http://www.dotredconsultancy.com/openglrenderingenginetoolsourcecodelicence.php
  Please contact Thanos Theo (thanos.theo@dotredconsultancy.com) for more information.

*/

/**
*
*  Apply FXAA Antialias GLSL code.
*
* @author Thanos Theo, 2009-2018
* @version 14.0.0.0
*/

uniform sampler2D frameBufferSampler;
uniform vec2 frameBufferResolution = vec2(512, 512);
uniform float FXAA_SpanMax   = 8.0;
uniform float FXAA_ReduceMul = 1.0 / 8.0;
uniform float FXAA_ReduceMin = 1.0 / 128.0;

const vec3 LUMA = vec3(0.299, 0.587, 0.114);

void main()
{
  vec3 rgbNW = texture2D(frameBufferSampler, gl_TexCoord[0].st + (vec2(-1.0, -1.0) / frameBufferResolution)).xyz;
  vec3 rgbNE = texture2D(frameBufferSampler, gl_TexCoord[0].st + (vec2( 1.0, -1.0) / frameBufferResolution)).xyz;
  vec3 rgbSW = texture2D(frameBufferSampler, gl_TexCoord[0].st + (vec2(-1.0,  1.0) / frameBufferResolution)).xyz;
  vec3 rgbSE = texture2D(frameBufferSampler, gl_TexCoord[0].st + (vec2( 1.0,  1.0) / frameBufferResolution)).xyz;
  vec4 rgbM  = texture2D(frameBufferSampler, gl_TexCoord[0].st);

  float lumaNW = dot(rgbNW,    LUMA);
  float lumaNE = dot(rgbNE,    LUMA);
  float lumaSW = dot(rgbSW,    LUMA);
  float lumaSE = dot(rgbSE,    LUMA);
  float lumaM  = dot(rgbM.rgb, LUMA);

  float lumaMin = min(lumaM, min(min(lumaNW, lumaNE), min(lumaSW, lumaSE)));
  float lumaMax = max(lumaM, max(max(lumaNW, lumaNE), max(lumaSW, lumaSE)));

  vec2 dir = vec2(-((lumaNW + lumaNE) - (lumaSW + lumaSE)), ((lumaNW + lumaSW) - (lumaNE + lumaSE)));
  float dirReduce = max((lumaNW + lumaNE + lumaSW + lumaSE) * (0.25 * FXAA_ReduceMul), FXAA_ReduceMin);
  float rcpDirMin = 1.0 / (min(abs(dir.x), abs(dir.y)) + dirReduce);

  dir = min(vec2(FXAA_SpanMax, FXAA_SpanMax), max(vec2(-FXAA_SpanMax, -FXAA_SpanMax), dir * rcpDirMin)) / frameBufferResolution;

  vec3 rgbA   = (1.0 / 2.0) * (texture2D(frameBufferSampler, gl_TexCoord[0].st + dir * (1.0 / 3.0 - 0.5)).xyz + texture2D(frameBufferSampler, gl_TexCoord[0].st + dir * (2.0 / 3.0 - 0.5)).xyz);
  vec3 rgbB   = rgbA * (1.0 / 2.0) + (1.0 / 4.0) * (texture2D(frameBufferSampler, gl_TexCoord[0].st + dir * (0.0 / 3.0 - 0.5)).xyz + texture2D(frameBufferSampler, gl_TexCoord[0].st + dir * (3.0 / 3.0 - 0.5)).xyz);
  float lumaB = dot(rgbB, LUMA);

  gl_FragColor = ((lumaB < lumaMin) || (lumaB > lumaMax)) ? vec4(rgbA, rgbM.a) : vec4(rgbB, rgbM.a);
}